% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{PCA-class}
\alias{PCA-class}
\alias{.PCA}
\title{PCA Results}
\description{
An S4 class to store the results of a principal components analysis.
}
\section{Slots}{

\describe{
\item{\code{center}}{A \code{\link{numeric}} vector giving the column mean of the initial
dataset (active individuals only).}

\item{\code{scale}}{A \code{\link{numeric}} vector giving the column standard deviations of the
initial dataset (active individuals only).}
}}

\note{
This class inherits from \code{\linkS4class{MultivariateAnalysis}}.
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, sup_quali = "Species")

## Get eigenvalues
get_eigenvalues(X)

## Get individual cos2
head(get_cos2(X, margin = 1))

## Get variable contributions
get_contributions(X, margin = 2)

## Get correlations between variables and dimensions
get_correlations(X)
}
\seealso{
Other class: 
\code{\link{BootstrapCA-class}},
\code{\link{BootstrapPCA-class}},
\code{\link{CA-class}},
\code{\link{MCA-class}},
\code{\link{MultivariateAnalysis}},
\code{\link{MultivariateBootstrap}},
\code{\link{MultivariateResults}},
\code{\link{MultivariateSummary}},
\code{\link{PCOA-class}}
}
\author{
N. Frerebeau
}
\concept{class}
\keyword{internal}
