% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot.R
\docType{methods}
\name{plot_eigenvalues}
\alias{plot_eigenvalues}
\alias{plot_variance}
\alias{plot_variance-method}
\alias{plot_variance,MultivariateAnalysis-method}
\title{Visualize Eigenvalues}
\usage{
plot_variance(object, ...)

\S4method{plot_variance}{MultivariateAnalysis}(
  object,
  variance = TRUE,
  cumulative = TRUE,
  fill = "grey30",
  border = "grey10",
  color = "red"
)
}
\arguments{
\item{object}{A \code{\linkS4class{CA}} or \code{\linkS4class{PCA}} object.}

\item{...}{Currently not used.}

\item{variance}{A \code{\link{logical}} scalar: should the percentages of variance be
plotted instead of the eigenvalues?}

\item{cumulative}{A \code{\link{logical}} scalar: should the cumulative percentages of
variance be plotted?}

\item{fill, border}{A \code{\link{character}} string specifying the bars infilling and
border colors.}

\item{color}{A \code{\link{character}} string specifying the line color.}
}
\description{
Plot eigenvalues or variances histogram.
}
\examples{
## Load data
data("zuni", package = "folio")

## Compute correspondence analysis
X <- ca(zuni)

## Plot observations
plot(X)

## Screeplot
plot_variance(X)
}
\seealso{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}

Other plot: 
\code{\link{plot_contributions}()},
\code{\link{plot_coordinates}}
}
\author{
N. Frerebeau
}
\concept{plot}
