% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_ym.R
\name{format.date_ym}
\alias{format.date_ym}
\alias{format_date_ym_iso}
\alias{format_date_ym_short}
\alias{format_date_ym_shorter}
\title{Format a date_ym Object}
\usage{
\method{format}{date_ym}(x, format = "iso", ...)

format_date_ym_iso(x)

format_date_ym_short(x)

format_date_ym_shorter(x)
}
\arguments{
\item{x}{a \link{date_ym} object}

\item{format}{A scalar character, valid values are: \code{"iso"}, \code{"short"}, and
\code{"shorter"}}

\item{...}{ignored}
}
\value{
A character vector
}
\description{
Format a date_ym Object
}
\examples{

x <- date_ym(2015, 12)

format(x, format = "iso")
# [1] "2015-M12"

format(x, format = "short")
# [1] "2015.12"

format(x, format = "shorter")
# [1] "15.12"

}
