% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp-collapse.R
\name{shift_array}
\alias{shift_array}
\title{Shift Array by Index}
\usage{
shift_array(x, shift_idx, shift_by, shift_amount)
}
\arguments{
\item{x}{array, must have at least matrix}

\item{shift_idx}{which index is to be shifted}

\item{shift_by}{which dimension decides \code{shift_amount}}

\item{shift_amount}{shift amount along \code{shift_idx}}
}
\description{
Re-arrange arrays in parallel
}
\details{
A simple use-case for this function is to think of a matrix where each row
is a signal and columns stand for time. The objective is to align (time-lock)
each signal according to certain events. For each signal, we want to shift
the time points by certain amount.

In this case, the shift amount is defined by \code{shift_amount}, whose
length equals to number of signals. \code{shift_idx=2} as we want to shift
time points (column, the second dimension) for each signal. \code{shift_by=1}
because the shift amount is depend on the signal number.
}
\examples{
x <- matrix(1:10, nrow = 2, byrow = TRUE)
z <- shift_array(x, 2, 1, c(1,2))

y <- NA * x
y[1,1:4] = x[1,2:5]
y[2,1:3] = x[2,3:5]

# Check if z ang y are the same
z - y

# array case
# x is Trial x Frequency x Time
x <- array(1:27, c(3,3,3))

# Shift time for each trial, amount is 1, -1, 0
shift_amount <- c(1,-1,0)
z <- shift_array(x, 3, 1, shift_amount)
par(mfrow = c(3, 2))
for( ii in 1:3 ){
  image(t(x[ii, ,]), ylab = 'Frequency', xlab = 'Time',
        main = paste('Trial', ii))
  image(t(z[ii, ,]), ylab = 'Frequency', xlab = 'Time',
        main = paste('Shifted amount:', shift_amount[ii]))
}

}
