% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{\%=>\%}
\alias{\%=>\%}
\title{A JavaScript style of creating functions}
\usage{
args \%=>\% expr
}
\arguments{
\item{args}{function arguments: see \code{\link[base]{formals}}}

\item{expr}{R expression that forms the body of functions: see \code{\link[base]{body}}}
}
\value{
A function that takes \code{args} as parameters and \code{expr} as
the function body
}
\description{
A JavaScript style of creating functions
}
\examples{
# Formal arguments
c(a) \%=>\% {
  print(a)
}

# Informal arguments
list(a=) \%=>\% {
  print(a)
}

# Multiple inputs
c(a, b = 2, ...) \%=>\% {
  print(c(a, b, ...))
}

# ----- JavaScript style of forEach -----
# ### Equivalent JavaScript Code:
# LETTERS.forEach((el, ii) => {
#   console.log('The index of letter ' + el + ' in "x" is: ' + ii);
# });

iapply(LETTERS, c(el, ii) \%=>\% {
  cat2('The index of letter ', el, ' in ', sQuote('x'), ' is: ', ii)
}) -> results
}
