// Generated by rstantools.  Do not edit by hand.

/*
    disbayes is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    disbayes is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with disbayes.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_disbayes_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_disbayes");
    reader.add_event(0, 0, "include", "/include/trans_probs.stan");
    reader.add_event(0, 0, "start", "/include/trans_probs.stan");
    reader.add_event(100, 100, "end", "/include/trans_probs.stan");
    reader.add_event(100, 1, "restart", "model_disbayes");
    reader.add_event(403, 302, "end", "model_disbayes");
    return reader;
}
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_rem(const T0__& i,
                    const T1__& f,
                    const T2__& r, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 10;
        local_scalar_t__ l(DUMMY_VAR__);
        (void) l;  // dummy to suppress unused var warning
        stan::math::initialize(l, DUMMY_VAR__);
        stan::math::fill(l, DUMMY_VAR__);
        stan::math::assign(l,((i + r) + f));
        current_statement_begin__ = 11;
        local_scalar_t__ q(DUMMY_VAR__);
        (void) q;  // dummy to suppress unused var warning
        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q, DUMMY_VAR__);
        stan::math::assign(q,stan::math::sqrt(((((((i * i) + ((2 * i) * r)) - ((2 * i) * f)) + (r * r)) + ((2 * f) * r)) + (f * f))));
        current_statement_begin__ = 12;
        local_scalar_t__ w(DUMMY_VAR__);
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, DUMMY_VAR__);
        stan::math::fill(w, DUMMY_VAR__);
        stan::math::assign(w,stan::math::exp((-((l + q)) / 2)));
        current_statement_begin__ = 13;
        local_scalar_t__ v(DUMMY_VAR__);
        (void) v;  // dummy to suppress unused var warning
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);
        stan::math::assign(v,stan::math::exp((-((l - q)) / 2)));
        current_statement_begin__ = 14;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 15;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((((2 * (v - w)) * (f + r)) + (v * (q - l))) + (w * (q + l))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 16;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((v - w) * r) / q), 
                    "assigning variable P");
        current_statement_begin__ = 17;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 19;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    ((i * (v - w)) / q), 
                    "assigning variable P");
        current_statement_begin__ = 20;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (-(((((2 * (f + r)) - l) * (v - w)) - (q * (v + w)))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 21;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 23;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((((-(l) * (v - w)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 24;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (((((v - w) * ((2 * f) - l)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 25;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 26;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_rem_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                    const T1__& f,
                    const T2__& r, std::ostream* pstream__) const {
        return trans_probs_rem(i, f, r, pstream__);
    }
};
template <typename T0__, typename T1__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_norem_if(const T0__& i,
                         const T1__& f, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 30;
        local_scalar_t__ l(DUMMY_VAR__);
        (void) l;  // dummy to suppress unused var warning
        stan::math::initialize(l, DUMMY_VAR__);
        stan::math::fill(l, DUMMY_VAR__);
        stan::math::assign(l,(i + f));
        current_statement_begin__ = 31;
        local_scalar_t__ q(DUMMY_VAR__);
        (void) q;  // dummy to suppress unused var warning
        stan::math::initialize(q, DUMMY_VAR__);
        stan::math::fill(q, DUMMY_VAR__);
        stan::math::assign(q,stan::math::sqrt((((i * i) - ((2 * i) * f)) + (f * f))));
        current_statement_begin__ = 32;
        local_scalar_t__ w(DUMMY_VAR__);
        (void) w;  // dummy to suppress unused var warning
        stan::math::initialize(w, DUMMY_VAR__);
        stan::math::fill(w, DUMMY_VAR__);
        stan::math::assign(w,stan::math::exp((-((l + q)) / 2)));
        current_statement_begin__ = 33;
        local_scalar_t__ v(DUMMY_VAR__);
        (void) v;  // dummy to suppress unused var warning
        stan::math::initialize(v, DUMMY_VAR__);
        stan::math::fill(v, DUMMY_VAR__);
        stan::math::assign(v,stan::math::exp((-((l - q)) / 2)));
        current_statement_begin__ = 34;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 35;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    (((((2 * (v - w)) * f) + (v * (q - l))) + (w * (q + l))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 36;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 37;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 39;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    ((i * (v - w)) / q), 
                    "assigning variable P");
        current_statement_begin__ = 40;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (-(((((2 * f) - l) * (v - w)) - (q * (v + w)))) / (2 * q)), 
                    "assigning variable P");
        current_statement_begin__ = 41;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 43;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((((-(l) * (v - w)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 44;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (((((v - w) * ((2 * f) - l)) - (q * (v + w))) / (2 * q)) + 1), 
                    "assigning variable P");
        current_statement_begin__ = 45;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 46;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_norem_if_functor__ {
    template <typename T0__, typename T1__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                         const T1__& f, std::ostream* pstream__) const {
        return trans_probs_norem_if(i, f, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs_norem_i(const T0__& i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 50;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 51;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    stan::math::exp(-(i)), 
                    "assigning variable P");
        current_statement_begin__ = 52;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    (i * stan::math::exp(-(i))), 
                    "assigning variable P");
        current_statement_begin__ = 53;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    ((-(stan::math::exp(-(i))) + 1) - (i * stan::math::exp(-(i)))), 
                    "assigning variable P");
        current_statement_begin__ = 55;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 56;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    stan::math::exp(-(i)), 
                    "assigning variable P");
        current_statement_begin__ = 57;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(2), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    (1 - stan::math::exp(-(i))), 
                    "assigning variable P");
        current_statement_begin__ = 59;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 60;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                    0, 
                    "assigning variable P");
        current_statement_begin__ = 61;
        stan::model::assign(P, 
                    stan::model::cons_list(stan::model::index_uni(3), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())), 
                    1, 
                    "assigning variable P");
        current_statement_begin__ = 62;
        return stan::math::promote_scalar<fun_return_scalar_t__>(P);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_norem_i_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i, std::ostream* pstream__) const {
        return trans_probs_norem_i(i, pstream__);
    }
};
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
defuzz_P(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& P, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 66;
        validate_non_negative_index("Pr", "3", 3);
        validate_non_negative_index("Pr", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Pr(3, 3);
        stan::math::initialize(Pr, DUMMY_VAR__);
        stan::math::fill(Pr, DUMMY_VAR__);
        current_statement_begin__ = 67;
        for (int r = 1; r <= 3; ++r) {
            current_statement_begin__ = 68;
            for (int s = 1; s <= 3; ++s) {
                current_statement_begin__ = 69;
                stan::model::assign(Pr, 
                            stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                            get_base1(P, r, s, "P", 1), 
                            "assigning variable Pr");
                current_statement_begin__ = 70;
                if (as_bool(logical_lt(get_base1(P, r, s, "P", 1), 0))) {
                    current_statement_begin__ = 70;
                    stan::model::assign(Pr, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable Pr");
                }
                current_statement_begin__ = 71;
                if (as_bool(logical_gt(get_base1(P, r, s, "P", 1), 1))) {
                    current_statement_begin__ = 71;
                    stan::model::assign(Pr, 
                                stan::model::cons_list(stan::model::index_uni(r), stan::model::cons_list(stan::model::index_uni(s), stan::model::nil_index_list())), 
                                1, 
                                "assigning variable Pr");
                }
            }
        }
        current_statement_begin__ = 74;
        return stan::math::promote_scalar<fun_return_scalar_t__>(Pr);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct defuzz_P_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& P, std::ostream* pstream__) const {
        return defuzz_P(P, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
trans_probs(const T0__& i,
                const T1__& f,
                const T2__& r, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 78;
        validate_non_negative_index("P", "3", 3);
        validate_non_negative_index("P", "3", 3);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
        stan::math::initialize(P, DUMMY_VAR__);
        stan::math::fill(P, DUMMY_VAR__);
        current_statement_begin__ = 79;
        if (as_bool(logical_neq(r, 0))) {
            current_statement_begin__ = 80;
            stan::math::assign(P, trans_probs_rem(i, f, r, pstream__));
        } else {
            current_statement_begin__ = 82;
            if (as_bool(logical_eq(i, f))) {
                current_statement_begin__ = 83;
                stan::math::assign(P, trans_probs_norem_i(i, pstream__));
            } else {
                current_statement_begin__ = 85;
                stan::math::assign(P, trans_probs_norem_if(i, f, pstream__));
            }
        }
        current_statement_begin__ = 87;
        return stan::math::promote_scalar<fun_return_scalar_t__>(defuzz_P(P, pstream__));
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct trans_probs_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const T0__& i,
                const T1__& f,
                const T2__& r, std::ostream* pstream__) const {
        return trans_probs(i, f, r, pstream__);
    }
};
template <typename T0__>
typename boost::math::tools::promote_args<T0__>::type
bound_prob(const T0__& x, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 91;
        local_scalar_t__ ret(DUMMY_VAR__);
        (void) ret;  // dummy to suppress unused var warning
        stan::math::initialize(ret, DUMMY_VAR__);
        stan::math::fill(ret, DUMMY_VAR__);
        current_statement_begin__ = 92;
        if (as_bool(logical_gte(x, 1))) {
            current_statement_begin__ = 93;
            stan::math::assign(ret, (1 - stan::math::machine_precision()));
        } else if (as_bool(logical_lte(x, 0))) {
            current_statement_begin__ = 95;
            stan::math::assign(ret, stan::math::machine_precision());
        } else {
            current_statement_begin__ = 96;
            stan::math::assign(ret, x);
        }
        current_statement_begin__ = 97;
        return stan::math::promote_scalar<fun_return_scalar_t__>(x);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct bound_prob_functor__ {
    template <typename T0__>
        typename boost::math::tools::promote_args<T0__>::type
    operator()(const T0__& x, std::ostream* pstream__) const {
        return bound_prob(x, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_disbayes
  : public stan::model::model_base_crtp<model_disbayes> {
private:
        int inc_supplied;
        int prev_supplied;
        int smooth_cf;
        int smooth_inc;
        int smooth_rem;
        int remission;
        int trend;
        int prev_zero;
        int nage;
        int eqage;
        std::vector<int> mort_num;
        std::vector<int> mort_denom;
        std::vector<int> prev_num;
        std::vector<int> prev_denom;
        std::vector<int> inc_num;
        std::vector<int> inc_denom;
        std::vector<int> rem_num;
        std::vector<int> rem_denom;
        int nyr;
        int K;
        matrix_d X;
        std::vector<double> sprior;
        int increasing_cf;
        int const_cf;
        int const_rem;
        int nbias;
        int incdata_ind;
        int prevdata_ind;
        matrix_d inc_trend;
        matrix_d cf_trend;
        std::vector<double> inc_prior;
        std::vector<double> cf_prior;
        std::vector<double> rem_prior;
        int scf_isfixed;
        int sinc_isfixed;
        int srem_isfixed;
        double lambda_cf_fixed;
        double lambda_inc_fixed;
        double lambda_rem_fixed;
public:
    model_disbayes(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_disbayes(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_disbayes_namespace::model_disbayes";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 103;
            context__.validate_dims("data initialization", "inc_supplied", "int", context__.to_vec());
            inc_supplied = int(0);
            vals_i__ = context__.vals_i("inc_supplied");
            pos__ = 0;
            inc_supplied = vals_i__[pos__++];
            current_statement_begin__ = 104;
            context__.validate_dims("data initialization", "prev_supplied", "int", context__.to_vec());
            prev_supplied = int(0);
            vals_i__ = context__.vals_i("prev_supplied");
            pos__ = 0;
            prev_supplied = vals_i__[pos__++];
            current_statement_begin__ = 105;
            context__.validate_dims("data initialization", "smooth_cf", "int", context__.to_vec());
            smooth_cf = int(0);
            vals_i__ = context__.vals_i("smooth_cf");
            pos__ = 0;
            smooth_cf = vals_i__[pos__++];
            current_statement_begin__ = 106;
            context__.validate_dims("data initialization", "smooth_inc", "int", context__.to_vec());
            smooth_inc = int(0);
            vals_i__ = context__.vals_i("smooth_inc");
            pos__ = 0;
            smooth_inc = vals_i__[pos__++];
            current_statement_begin__ = 107;
            context__.validate_dims("data initialization", "smooth_rem", "int", context__.to_vec());
            smooth_rem = int(0);
            vals_i__ = context__.vals_i("smooth_rem");
            pos__ = 0;
            smooth_rem = vals_i__[pos__++];
            current_statement_begin__ = 108;
            context__.validate_dims("data initialization", "remission", "int", context__.to_vec());
            remission = int(0);
            vals_i__ = context__.vals_i("remission");
            pos__ = 0;
            remission = vals_i__[pos__++];
            current_statement_begin__ = 109;
            context__.validate_dims("data initialization", "trend", "int", context__.to_vec());
            trend = int(0);
            vals_i__ = context__.vals_i("trend");
            pos__ = 0;
            trend = vals_i__[pos__++];
            current_statement_begin__ = 110;
            context__.validate_dims("data initialization", "prev_zero", "int", context__.to_vec());
            prev_zero = int(0);
            vals_i__ = context__.vals_i("prev_zero");
            pos__ = 0;
            prev_zero = vals_i__[pos__++];
            current_statement_begin__ = 111;
            context__.validate_dims("data initialization", "nage", "int", context__.to_vec());
            nage = int(0);
            vals_i__ = context__.vals_i("nage");
            pos__ = 0;
            nage = vals_i__[pos__++];
            check_greater_or_equal(function__, "nage", nage, 0);
            current_statement_begin__ = 112;
            context__.validate_dims("data initialization", "eqage", "int", context__.to_vec());
            eqage = int(0);
            vals_i__ = context__.vals_i("eqage");
            pos__ = 0;
            eqage = vals_i__[pos__++];
            check_greater_or_equal(function__, "eqage", eqage, 0);
            current_statement_begin__ = 113;
            validate_non_negative_index("mort_num", "nage", nage);
            context__.validate_dims("data initialization", "mort_num", "int", context__.to_vec(nage));
            mort_num = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("mort_num");
            pos__ = 0;
            size_t mort_num_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < mort_num_k_0_max__; ++k_0__) {
                mort_num[k_0__] = vals_i__[pos__++];
            }
            size_t mort_num_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < mort_num_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mort_num[i_0__]", mort_num[i_0__], 0);
            }
            current_statement_begin__ = 114;
            validate_non_negative_index("mort_denom", "nage", nage);
            context__.validate_dims("data initialization", "mort_denom", "int", context__.to_vec(nage));
            mort_denom = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("mort_denom");
            pos__ = 0;
            size_t mort_denom_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < mort_denom_k_0_max__; ++k_0__) {
                mort_denom[k_0__] = vals_i__[pos__++];
            }
            size_t mort_denom_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < mort_denom_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mort_denom[i_0__]", mort_denom[i_0__], 0);
            }
            current_statement_begin__ = 115;
            validate_non_negative_index("prev_num", "nage", nage);
            context__.validate_dims("data initialization", "prev_num", "int", context__.to_vec(nage));
            prev_num = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("prev_num");
            pos__ = 0;
            size_t prev_num_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < prev_num_k_0_max__; ++k_0__) {
                prev_num[k_0__] = vals_i__[pos__++];
            }
            size_t prev_num_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < prev_num_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prev_num[i_0__]", prev_num[i_0__], 0);
            }
            current_statement_begin__ = 116;
            validate_non_negative_index("prev_denom", "nage", nage);
            context__.validate_dims("data initialization", "prev_denom", "int", context__.to_vec(nage));
            prev_denom = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("prev_denom");
            pos__ = 0;
            size_t prev_denom_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < prev_denom_k_0_max__; ++k_0__) {
                prev_denom[k_0__] = vals_i__[pos__++];
            }
            size_t prev_denom_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < prev_denom_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "prev_denom[i_0__]", prev_denom[i_0__], 0);
            }
            current_statement_begin__ = 117;
            validate_non_negative_index("inc_num", "nage", nage);
            context__.validate_dims("data initialization", "inc_num", "int", context__.to_vec(nage));
            inc_num = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("inc_num");
            pos__ = 0;
            size_t inc_num_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < inc_num_k_0_max__; ++k_0__) {
                inc_num[k_0__] = vals_i__[pos__++];
            }
            size_t inc_num_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < inc_num_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "inc_num[i_0__]", inc_num[i_0__], 0);
            }
            current_statement_begin__ = 118;
            validate_non_negative_index("inc_denom", "nage", nage);
            context__.validate_dims("data initialization", "inc_denom", "int", context__.to_vec(nage));
            inc_denom = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("inc_denom");
            pos__ = 0;
            size_t inc_denom_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < inc_denom_k_0_max__; ++k_0__) {
                inc_denom[k_0__] = vals_i__[pos__++];
            }
            size_t inc_denom_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < inc_denom_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "inc_denom[i_0__]", inc_denom[i_0__], 0);
            }
            current_statement_begin__ = 119;
            validate_non_negative_index("rem_num", "nage", nage);
            context__.validate_dims("data initialization", "rem_num", "int", context__.to_vec(nage));
            rem_num = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("rem_num");
            pos__ = 0;
            size_t rem_num_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < rem_num_k_0_max__; ++k_0__) {
                rem_num[k_0__] = vals_i__[pos__++];
            }
            size_t rem_num_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < rem_num_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rem_num[i_0__]", rem_num[i_0__], 0);
            }
            current_statement_begin__ = 120;
            validate_non_negative_index("rem_denom", "nage", nage);
            context__.validate_dims("data initialization", "rem_denom", "int", context__.to_vec(nage));
            rem_denom = std::vector<int>(nage, int(0));
            vals_i__ = context__.vals_i("rem_denom");
            pos__ = 0;
            size_t rem_denom_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < rem_denom_k_0_max__; ++k_0__) {
                rem_denom[k_0__] = vals_i__[pos__++];
            }
            size_t rem_denom_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < rem_denom_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rem_denom[i_0__]", rem_denom[i_0__], 0);
            }
            current_statement_begin__ = 121;
            context__.validate_dims("data initialization", "nyr", "int", context__.to_vec());
            nyr = int(0);
            vals_i__ = context__.vals_i("nyr");
            pos__ = 0;
            nyr = vals_i__[pos__++];
            check_greater_or_equal(function__, "nyr", nyr, 0);
            current_statement_begin__ = 124;
            context__.validate_dims("data initialization", "K", "int", context__.to_vec());
            K = int(0);
            vals_i__ = context__.vals_i("K");
            pos__ = 0;
            K = vals_i__[pos__++];
            check_greater_or_equal(function__, "K", K, 0);
            current_statement_begin__ = 125;
            validate_non_negative_index("X", "nage", nage);
            validate_non_negative_index("X", "K", K);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(nage,K));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nage, K);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = K;
            size_t X_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 126;
            validate_non_negative_index("sprior", "3", 3);
            context__.validate_dims("data initialization", "sprior", "double", context__.to_vec(3));
            sprior = std::vector<double>(3, double(0));
            vals_r__ = context__.vals_r("sprior");
            pos__ = 0;
            size_t sprior_k_0_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < sprior_k_0_max__; ++k_0__) {
                sprior[k_0__] = vals_r__[pos__++];
            }
            size_t sprior_i_0_max__ = 3;
            for (size_t i_0__ = 0; i_0__ < sprior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "sprior[i_0__]", sprior[i_0__], 0);
            }
            current_statement_begin__ = 129;
            context__.validate_dims("data initialization", "increasing_cf", "int", context__.to_vec());
            increasing_cf = int(0);
            vals_i__ = context__.vals_i("increasing_cf");
            pos__ = 0;
            increasing_cf = vals_i__[pos__++];
            current_statement_begin__ = 130;
            context__.validate_dims("data initialization", "const_cf", "int", context__.to_vec());
            const_cf = int(0);
            vals_i__ = context__.vals_i("const_cf");
            pos__ = 0;
            const_cf = vals_i__[pos__++];
            current_statement_begin__ = 131;
            context__.validate_dims("data initialization", "const_rem", "int", context__.to_vec());
            const_rem = int(0);
            vals_i__ = context__.vals_i("const_rem");
            pos__ = 0;
            const_rem = vals_i__[pos__++];
            current_statement_begin__ = 133;
            context__.validate_dims("data initialization", "nbias", "int", context__.to_vec());
            nbias = int(0);
            vals_i__ = context__.vals_i("nbias");
            pos__ = 0;
            nbias = vals_i__[pos__++];
            current_statement_begin__ = 135;
            context__.validate_dims("data initialization", "incdata_ind", "int", context__.to_vec());
            incdata_ind = int(0);
            vals_i__ = context__.vals_i("incdata_ind");
            pos__ = 0;
            incdata_ind = vals_i__[pos__++];
            current_statement_begin__ = 136;
            context__.validate_dims("data initialization", "prevdata_ind", "int", context__.to_vec());
            prevdata_ind = int(0);
            vals_i__ = context__.vals_i("prevdata_ind");
            pos__ = 0;
            prevdata_ind = vals_i__[pos__++];
            current_statement_begin__ = 140;
            validate_non_negative_index("inc_trend", "nage", nage);
            validate_non_negative_index("inc_trend", "nyr", nyr);
            context__.validate_dims("data initialization", "inc_trend", "matrix_d", context__.to_vec(nage,nyr));
            inc_trend = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nage, nyr);
            vals_r__ = context__.vals_r("inc_trend");
            pos__ = 0;
            size_t inc_trend_j_2_max__ = nyr;
            size_t inc_trend_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < inc_trend_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < inc_trend_j_1_max__; ++j_1__) {
                    inc_trend(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "inc_trend", inc_trend, 0);
            current_statement_begin__ = 141;
            validate_non_negative_index("cf_trend", "nage", nage);
            validate_non_negative_index("cf_trend", "nyr", nyr);
            context__.validate_dims("data initialization", "cf_trend", "matrix_d", context__.to_vec(nage,nyr));
            cf_trend = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nage, nyr);
            vals_r__ = context__.vals_r("cf_trend");
            pos__ = 0;
            size_t cf_trend_j_2_max__ = nyr;
            size_t cf_trend_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < cf_trend_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < cf_trend_j_1_max__; ++j_1__) {
                    cf_trend(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "cf_trend", cf_trend, 0);
            current_statement_begin__ = 143;
            validate_non_negative_index("inc_prior", "2", 2);
            context__.validate_dims("data initialization", "inc_prior", "double", context__.to_vec(2));
            inc_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("inc_prior");
            pos__ = 0;
            size_t inc_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < inc_prior_k_0_max__; ++k_0__) {
                inc_prior[k_0__] = vals_r__[pos__++];
            }
            size_t inc_prior_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < inc_prior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "inc_prior[i_0__]", inc_prior[i_0__], 0);
            }
            current_statement_begin__ = 144;
            validate_non_negative_index("cf_prior", "2", 2);
            context__.validate_dims("data initialization", "cf_prior", "double", context__.to_vec(2));
            cf_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("cf_prior");
            pos__ = 0;
            size_t cf_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < cf_prior_k_0_max__; ++k_0__) {
                cf_prior[k_0__] = vals_r__[pos__++];
            }
            size_t cf_prior_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < cf_prior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "cf_prior[i_0__]", cf_prior[i_0__], 0);
            }
            current_statement_begin__ = 145;
            validate_non_negative_index("rem_prior", "2", 2);
            context__.validate_dims("data initialization", "rem_prior", "double", context__.to_vec(2));
            rem_prior = std::vector<double>(2, double(0));
            vals_r__ = context__.vals_r("rem_prior");
            pos__ = 0;
            size_t rem_prior_k_0_max__ = 2;
            for (size_t k_0__ = 0; k_0__ < rem_prior_k_0_max__; ++k_0__) {
                rem_prior[k_0__] = vals_r__[pos__++];
            }
            size_t rem_prior_i_0_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < rem_prior_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "rem_prior[i_0__]", rem_prior[i_0__], 0);
            }
            current_statement_begin__ = 148;
            context__.validate_dims("data initialization", "scf_isfixed", "int", context__.to_vec());
            scf_isfixed = int(0);
            vals_i__ = context__.vals_i("scf_isfixed");
            pos__ = 0;
            scf_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 149;
            context__.validate_dims("data initialization", "sinc_isfixed", "int", context__.to_vec());
            sinc_isfixed = int(0);
            vals_i__ = context__.vals_i("sinc_isfixed");
            pos__ = 0;
            sinc_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 150;
            context__.validate_dims("data initialization", "srem_isfixed", "int", context__.to_vec());
            srem_isfixed = int(0);
            vals_i__ = context__.vals_i("srem_isfixed");
            pos__ = 0;
            srem_isfixed = vals_i__[pos__++];
            current_statement_begin__ = 151;
            context__.validate_dims("data initialization", "lambda_cf_fixed", "double", context__.to_vec());
            lambda_cf_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_cf_fixed");
            pos__ = 0;
            lambda_cf_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_cf_fixed", lambda_cf_fixed, 0);
            current_statement_begin__ = 152;
            context__.validate_dims("data initialization", "lambda_inc_fixed", "double", context__.to_vec());
            lambda_inc_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_inc_fixed");
            pos__ = 0;
            lambda_inc_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_inc_fixed", lambda_inc_fixed, 0);
            current_statement_begin__ = 153;
            context__.validate_dims("data initialization", "lambda_rem_fixed", "double", context__.to_vec());
            lambda_rem_fixed = double(0);
            vals_r__ = context__.vals_r("lambda_rem_fixed");
            pos__ = 0;
            lambda_rem_fixed = vals_r__[pos__++];
            check_greater_or_equal(function__, "lambda_rem_fixed", lambda_rem_fixed, 0);
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 157;
            validate_non_negative_index("inc_par", "(nage * (1 - smooth_inc))", (nage * (1 - smooth_inc)));
            num_params_r__ += (nage * (1 - smooth_inc));
            current_statement_begin__ = 158;
            validate_non_negative_index("cf_par", "(nage * (1 - smooth_cf))", (nage * (1 - smooth_cf)));
            num_params_r__ += (nage * (1 - smooth_cf));
            current_statement_begin__ = 159;
            validate_non_negative_index("rem_par", "((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))", ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
            num_params_r__ += ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
            current_statement_begin__ = 160;
            validate_non_negative_index("beta", "((K * smooth_cf) * (1 - const_cf))", ((K * smooth_cf) * (1 - const_cf)));
            num_params_r__ += ((K * smooth_cf) * (1 - const_cf));
            current_statement_begin__ = 161;
            validate_non_negative_index("lambda_cf", "(smooth_cf * (1 - scf_isfixed))", (smooth_cf * (1 - scf_isfixed)));
            num_params_r__ += (smooth_cf * (1 - scf_isfixed));
            current_statement_begin__ = 162;
            validate_non_negative_index("lambda_inc", "(smooth_inc * (1 - sinc_isfixed))", (smooth_inc * (1 - sinc_isfixed)));
            num_params_r__ += (smooth_inc * (1 - sinc_isfixed));
            current_statement_begin__ = 163;
            validate_non_negative_index("beta_inc", "(K * smooth_inc)", (K * smooth_inc));
            num_params_r__ += (K * smooth_inc);
            current_statement_begin__ = 164;
            validate_non_negative_index("lambda_rem", "(smooth_rem * (1 - srem_isfixed))", (smooth_rem * (1 - srem_isfixed)));
            num_params_r__ += (smooth_rem * (1 - srem_isfixed));
            current_statement_begin__ = 165;
            validate_non_negative_index("beta_rem", "(K * smooth_rem)", (K * smooth_rem));
            num_params_r__ += (K * smooth_rem);
            current_statement_begin__ = 166;
            validate_non_negative_index("prevzero", "prev_zero", prev_zero);
            num_params_r__ += prev_zero;
            current_statement_begin__ = 169;
            validate_non_negative_index("bias_loghr", "logical_eq(nbias, 2)", logical_eq(nbias, 2));
            num_params_r__ += logical_eq(nbias, 2);
            current_statement_begin__ = 171;
            validate_non_negative_index("cfbase", "(1 * increasing_cf)", (1 * increasing_cf));
            num_params_r__ += (1 * increasing_cf);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_disbayes() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 157;
        if (!(context__.contains_r("inc_par")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable inc_par missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("inc_par");
        pos__ = 0U;
        validate_non_negative_index("inc_par", "(nage * (1 - smooth_inc))", (nage * (1 - smooth_inc)));
        context__.validate_dims("parameter initialization", "inc_par", "vector_d", context__.to_vec((nage * (1 - smooth_inc))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> inc_par((nage * (1 - smooth_inc)));
        size_t inc_par_j_1_max__ = (nage * (1 - smooth_inc));
        for (size_t j_1__ = 0; j_1__ < inc_par_j_1_max__; ++j_1__) {
            inc_par(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, inc_par);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable inc_par: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 158;
        if (!(context__.contains_r("cf_par")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable cf_par missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("cf_par");
        pos__ = 0U;
        validate_non_negative_index("cf_par", "(nage * (1 - smooth_cf))", (nage * (1 - smooth_cf)));
        context__.validate_dims("parameter initialization", "cf_par", "vector_d", context__.to_vec((nage * (1 - smooth_cf))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> cf_par((nage * (1 - smooth_cf)));
        size_t cf_par_j_1_max__ = (nage * (1 - smooth_cf));
        for (size_t j_1__ = 0; j_1__ < cf_par_j_1_max__; ++j_1__) {
            cf_par(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, cf_par);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable cf_par: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 159;
        if (!(context__.contains_r("rem_par")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rem_par missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rem_par");
        pos__ = 0U;
        validate_non_negative_index("rem_par", "((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))", ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        context__.validate_dims("parameter initialization", "rem_par", "vector_d", context__.to_vec(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> rem_par(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        size_t rem_par_j_1_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        for (size_t j_1__ = 0; j_1__ < rem_par_j_1_max__; ++j_1__) {
            rem_par(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, rem_par);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rem_par: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 160;
        if (!(context__.contains_r("beta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        validate_non_negative_index("beta", "((K * smooth_cf) * (1 - const_cf))", ((K * smooth_cf) * (1 - const_cf)));
        context__.validate_dims("parameter initialization", "beta", "vector_d", context__.to_vec(((K * smooth_cf) * (1 - const_cf))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta(((K * smooth_cf) * (1 - const_cf)));
        size_t beta_j_1_max__ = ((K * smooth_cf) * (1 - const_cf));
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            beta(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 161;
        if (!(context__.contains_r("lambda_cf")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_cf missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_cf");
        pos__ = 0U;
        validate_non_negative_index("lambda_cf", "(smooth_cf * (1 - scf_isfixed))", (smooth_cf * (1 - scf_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_cf", "vector_d", context__.to_vec((smooth_cf * (1 - scf_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf((smooth_cf * (1 - scf_isfixed)));
        size_t lambda_cf_j_1_max__ = (smooth_cf * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            lambda_cf(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_cf);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_cf: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 162;
        if (!(context__.contains_r("lambda_inc")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_inc missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_inc");
        pos__ = 0U;
        validate_non_negative_index("lambda_inc", "(smooth_inc * (1 - sinc_isfixed))", (smooth_inc * (1 - sinc_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_inc", "vector_d", context__.to_vec((smooth_inc * (1 - sinc_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_inc((smooth_inc * (1 - sinc_isfixed)));
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            lambda_inc(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_inc);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_inc: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 163;
        if (!(context__.contains_r("beta_inc")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_inc missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_inc");
        pos__ = 0U;
        validate_non_negative_index("beta_inc", "(K * smooth_inc)", (K * smooth_inc));
        context__.validate_dims("parameter initialization", "beta_inc", "vector_d", context__.to_vec((K * smooth_inc)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_inc((K * smooth_inc));
        size_t beta_inc_j_1_max__ = (K * smooth_inc);
        for (size_t j_1__ = 0; j_1__ < beta_inc_j_1_max__; ++j_1__) {
            beta_inc(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_inc);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_inc: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 164;
        if (!(context__.contains_r("lambda_rem")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_rem missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_rem");
        pos__ = 0U;
        validate_non_negative_index("lambda_rem", "(smooth_rem * (1 - srem_isfixed))", (smooth_rem * (1 - srem_isfixed)));
        context__.validate_dims("parameter initialization", "lambda_rem", "vector_d", context__.to_vec((smooth_rem * (1 - srem_isfixed))));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rem((smooth_rem * (1 - srem_isfixed)));
        size_t lambda_rem_j_1_max__ = (smooth_rem * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            lambda_rem(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_rem);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_rem: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 165;
        if (!(context__.contains_r("beta_rem")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta_rem missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta_rem");
        pos__ = 0U;
        validate_non_negative_index("beta_rem", "(K * smooth_rem)", (K * smooth_rem));
        context__.validate_dims("parameter initialization", "beta_rem", "vector_d", context__.to_vec((K * smooth_rem)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_rem((K * smooth_rem));
        size_t beta_rem_j_1_max__ = (K * smooth_rem);
        for (size_t j_1__ = 0; j_1__ < beta_rem_j_1_max__; ++j_1__) {
            beta_rem(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta_rem);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta_rem: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 166;
        if (!(context__.contains_r("prevzero")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable prevzero missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("prevzero");
        pos__ = 0U;
        validate_non_negative_index("prevzero", "prev_zero", prev_zero);
        context__.validate_dims("parameter initialization", "prevzero", "vector_d", context__.to_vec(prev_zero));
        Eigen::Matrix<double, Eigen::Dynamic, 1> prevzero(prev_zero);
        size_t prevzero_j_1_max__ = prev_zero;
        for (size_t j_1__ = 0; j_1__ < prevzero_j_1_max__; ++j_1__) {
            prevzero(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 1, prevzero);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable prevzero: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 169;
        if (!(context__.contains_r("bias_loghr")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable bias_loghr missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("bias_loghr");
        pos__ = 0U;
        validate_non_negative_index("bias_loghr", "logical_eq(nbias, 2)", logical_eq(nbias, 2));
        context__.validate_dims("parameter initialization", "bias_loghr", "vector_d", context__.to_vec(logical_eq(nbias, 2)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> bias_loghr(logical_eq(nbias, 2));
        size_t bias_loghr_j_1_max__ = logical_eq(nbias, 2);
        for (size_t j_1__ = 0; j_1__ < bias_loghr_j_1_max__; ++j_1__) {
            bias_loghr(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(bias_loghr);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable bias_loghr: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 171;
        if (!(context__.contains_r("cfbase")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable cfbase missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("cfbase");
        pos__ = 0U;
        validate_non_negative_index("cfbase", "(1 * increasing_cf)", (1 * increasing_cf));
        context__.validate_dims("parameter initialization", "cfbase", "vector_d", context__.to_vec((1 * increasing_cf)));
        Eigen::Matrix<double, Eigen::Dynamic, 1> cfbase((1 * increasing_cf));
        size_t cfbase_j_1_max__ = (1 * increasing_cf);
        for (size_t j_1__ = 0; j_1__ < cfbase_j_1_max__; ++j_1__) {
            cfbase(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, cfbase);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable cfbase: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 157;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> inc_par;
            (void) inc_par;  // dummy to suppress unused var warning
            if (jacobian__)
                inc_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_inc)), lp__);
            else
                inc_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_inc)));
            current_statement_begin__ = 158;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cf_par;
            (void) cf_par;  // dummy to suppress unused var warning
            if (jacobian__)
                cf_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_cf)), lp__);
            else
                cf_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_cf)));
            current_statement_begin__ = 159;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rem_par;
            (void) rem_par;  // dummy to suppress unused var warning
            if (jacobian__)
                rem_par = in__.vector_lb_constrain(0, ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))), lp__);
            else
                rem_par = in__.vector_lb_constrain(0, ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
            current_statement_begin__ = 160;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.vector_constrain(((K * smooth_cf) * (1 - const_cf)), lp__);
            else
                beta = in__.vector_constrain(((K * smooth_cf) * (1 - const_cf)));
            current_statement_begin__ = 161;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_cf;
            (void) lambda_cf;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_cf = in__.vector_lb_constrain(0, (smooth_cf * (1 - scf_isfixed)), lp__);
            else
                lambda_cf = in__.vector_lb_constrain(0, (smooth_cf * (1 - scf_isfixed)));
            current_statement_begin__ = 162;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_inc;
            (void) lambda_inc;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)), lp__);
            else
                lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)));
            current_statement_begin__ = 163;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_inc;
            (void) beta_inc;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_inc = in__.vector_constrain((K * smooth_inc), lp__);
            else
                beta_inc = in__.vector_constrain((K * smooth_inc));
            current_statement_begin__ = 164;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_rem;
            (void) lambda_rem;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_rem = in__.vector_lb_constrain(0, (smooth_rem * (1 - srem_isfixed)), lp__);
            else
                lambda_rem = in__.vector_lb_constrain(0, (smooth_rem * (1 - srem_isfixed)));
            current_statement_begin__ = 165;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta_rem;
            (void) beta_rem;  // dummy to suppress unused var warning
            if (jacobian__)
                beta_rem = in__.vector_constrain((K * smooth_rem), lp__);
            else
                beta_rem = in__.vector_constrain((K * smooth_rem));
            current_statement_begin__ = 166;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> prevzero;
            (void) prevzero;  // dummy to suppress unused var warning
            if (jacobian__)
                prevzero = in__.vector_lub_constrain(0, 1, prev_zero, lp__);
            else
                prevzero = in__.vector_lub_constrain(0, 1, prev_zero);
            current_statement_begin__ = 169;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> bias_loghr;
            (void) bias_loghr;  // dummy to suppress unused var warning
            if (jacobian__)
                bias_loghr = in__.vector_constrain(logical_eq(nbias, 2), lp__);
            else
                bias_loghr = in__.vector_constrain(logical_eq(nbias, 2));
            current_statement_begin__ = 171;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cfbase;
            (void) cfbase;  // dummy to suppress unused var warning
            if (jacobian__)
                cfbase = in__.vector_lb_constrain(0, (1 * increasing_cf), lp__);
            else
                cfbase = in__.vector_lb_constrain(0, (1 * increasing_cf));
            // transformed parameters
            current_statement_begin__ = 175;
            validate_non_negative_index("cf", "nage", nage);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cf(nage);
            stan::math::initialize(cf, DUMMY_VAR__);
            stan::math::fill(cf, DUMMY_VAR__);
            current_statement_begin__ = 176;
            validate_non_negative_index("dcf", "(nage * increasing_cf)", (nage * increasing_cf));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> dcf((nage * increasing_cf));
            stan::math::initialize(dcf, DUMMY_VAR__);
            stan::math::fill(dcf, DUMMY_VAR__);
            current_statement_begin__ = 177;
            validate_non_negative_index("inc", "nage", nage);
            validate_non_negative_index("inc", "nbias", nbias);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> inc(nage, nbias);
            stan::math::initialize(inc, DUMMY_VAR__);
            stan::math::fill(inc, DUMMY_VAR__);
            current_statement_begin__ = 178;
            validate_non_negative_index("inc_prob", "nage", nage);
            validate_non_negative_index("inc_prob", "nbias", nbias);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> inc_prob(nage, nbias);
            stan::math::initialize(inc_prob, DUMMY_VAR__);
            stan::math::fill(inc_prob, DUMMY_VAR__);
            current_statement_begin__ = 179;
            validate_non_negative_index("rem", "nage", nage);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rem(nage);
            stan::math::initialize(rem, DUMMY_VAR__);
            stan::math::fill(rem, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("rem_prob", "(nage * remission)", (nage * remission));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> rem_prob((nage * remission));
            stan::math::initialize(rem_prob, DUMMY_VAR__);
            stan::math::fill(rem_prob, DUMMY_VAR__);
            current_statement_begin__ = 181;
            validate_non_negative_index("cf_prob", "nage", nage);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> cf_prob(nage);
            stan::math::initialize(cf_prob, DUMMY_VAR__);
            stan::math::fill(cf_prob, DUMMY_VAR__);
            current_statement_begin__ = 183;
            validate_non_negative_index("state_probs", "3", 3);
            validate_non_negative_index("state_probs", "((nage + 1) * (1 - trend))", ((nage + 1) * (1 - trend)));
            validate_non_negative_index("state_probs", "nbias", nbias);
            std::vector<std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > > state_probs(((nage + 1) * (1 - trend)), std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >(nbias, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(3)));
            stan::math::initialize(state_probs, DUMMY_VAR__);
            stan::math::fill(state_probs, DUMMY_VAR__);
            current_statement_begin__ = 184;
            validate_non_negative_index("tmp", "3", 3);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> tmp(3);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            current_statement_begin__ = 185;
            validate_non_negative_index("P", "3", 3);
            validate_non_negative_index("P", "3", 3);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P, DUMMY_VAR__);
            current_statement_begin__ = 186;
            validate_non_negative_index("prev_prob", "nage", nage);
            validate_non_negative_index("prev_prob", "nbias", nbias);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> prev_prob(nage, nbias);
            stan::math::initialize(prev_prob, DUMMY_VAR__);
            stan::math::fill(prev_prob, DUMMY_VAR__);
            current_statement_begin__ = 187;
            validate_non_negative_index("mort_prob", "nage", nage);
            std::vector<local_scalar_t__> mort_prob(nage, local_scalar_t__(0));
            stan::math::initialize(mort_prob, DUMMY_VAR__);
            stan::math::fill(mort_prob, DUMMY_VAR__);
            current_statement_begin__ = 189;
            validate_non_negative_index("cf_yr", "(nage * trend)", (nage * trend));
            validate_non_negative_index("cf_yr", "(nyr * trend)", (nyr * trend));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> cf_yr((nage * trend), (nyr * trend));
            stan::math::initialize(cf_yr, DUMMY_VAR__);
            stan::math::fill(cf_yr, DUMMY_VAR__);
            current_statement_begin__ = 190;
            validate_non_negative_index("inc_yr", "(nage * trend)", (nage * trend));
            validate_non_negative_index("inc_yr", "(nyr * trend)", (nyr * trend));
            validate_non_negative_index("inc_yr", "nbias", nbias);
            std::vector<std::vector<std::vector<local_scalar_t__> > > inc_yr((nage * trend), std::vector<std::vector<local_scalar_t__> >((nyr * trend), std::vector<local_scalar_t__>(nbias, local_scalar_t__(0))));
            stan::math::initialize(inc_yr, DUMMY_VAR__);
            stan::math::fill(inc_yr, DUMMY_VAR__);
            current_statement_begin__ = 191;
            validate_non_negative_index("state_probs_yr", "3", 3);
            validate_non_negative_index("state_probs_yr", "((nage + 1) * trend)", ((nage + 1) * trend));
            validate_non_negative_index("state_probs_yr", "(nyr * trend)", (nyr * trend));
            validate_non_negative_index("state_probs_yr", "nbias", nbias);
            std::vector<std::vector<std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > > > state_probs_yr(((nage + 1) * trend), std::vector<std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> > >((nyr * trend), std::vector<Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> >(nbias, Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic>(3))));
            stan::math::initialize(state_probs_yr, DUMMY_VAR__);
            stan::math::fill(state_probs_yr, DUMMY_VAR__);
            current_statement_begin__ = 193;
            local_scalar_t__ lambda_cf_use;
            (void) lambda_cf_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_use, DUMMY_VAR__);
            current_statement_begin__ = 194;
            local_scalar_t__ lambda_inc_use;
            (void) lambda_inc_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_inc_use, DUMMY_VAR__);
            stan::math::fill(lambda_inc_use, DUMMY_VAR__);
            current_statement_begin__ = 195;
            local_scalar_t__ lambda_rem_use;
            (void) lambda_rem_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_rem_use, DUMMY_VAR__);
            stan::math::fill(lambda_rem_use, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 196;
            if (as_bool((primitive_value(scf_isfixed) || primitive_value(logical_negation(smooth_cf))))) {
                current_statement_begin__ = 196;
                stan::math::assign(lambda_cf_use, lambda_cf_fixed);
            } else {
                current_statement_begin__ = 196;
                stan::math::assign(lambda_cf_use, get_base1(lambda_cf, 1, "lambda_cf", 1));
            }
            current_statement_begin__ = 197;
            if (as_bool((primitive_value(sinc_isfixed) || primitive_value(logical_negation(smooth_inc))))) {
                current_statement_begin__ = 197;
                stan::math::assign(lambda_inc_use, lambda_inc_fixed);
            } else {
                current_statement_begin__ = 197;
                stan::math::assign(lambda_inc_use, get_base1(lambda_inc, 1, "lambda_inc", 1));
            }
            current_statement_begin__ = 198;
            if (as_bool((primitive_value(srem_isfixed) || primitive_value(logical_negation(smooth_rem))))) {
                current_statement_begin__ = 198;
                stan::math::assign(lambda_rem_use, lambda_rem_fixed);
            } else {
                current_statement_begin__ = 198;
                stan::math::assign(lambda_rem_use, get_base1(lambda_rem, 1, "lambda_rem", 1));
            }
            current_statement_begin__ = 202;
            if (as_bool(smooth_inc)) {
                current_statement_begin__ = 202;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            stan::math::exp(multiply(X, beta_inc)), 
                            "assigning variable inc");
            } else {
                current_statement_begin__ = 202;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            inc_par, 
                            "assigning variable inc");
            }
            current_statement_begin__ = 203;
            if (as_bool(logical_gt(nbias, 1))) {
                current_statement_begin__ = 204;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            stan::model::deep_copy(stan::math::exp(add(stan::math::log(stan::model::rvalue(inc, stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "inc")), get_base1(bias_loghr, 1, "bias_loghr", 1)))), 
                            "assigning variable inc");
            }
            current_statement_begin__ = 206;
            if (as_bool(remission)) {
                current_statement_begin__ = 207;
                if (as_bool(const_rem)) {
                    current_statement_begin__ = 208;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 209;
                        stan::model::assign(rem, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                    get_base1(rem_par, 1, "rem_par", 1), 
                                    "assigning variable rem");
                    }
                } else if (as_bool(smooth_rem)) {
                    current_statement_begin__ = 211;
                    stan::math::assign(rem, stan::math::exp(multiply(X, beta_rem)));
                } else {
                    current_statement_begin__ = 212;
                    stan::math::assign(rem, rem_par);
                }
            } else {
                current_statement_begin__ = 213;
                stan::math::assign(rem, rep_vector(0, nage));
            }
            current_statement_begin__ = 216;
            for (int k = 1; k <= nbias; ++k) {
                current_statement_begin__ = 217;
                if (as_bool((primitive_value(logical_gt(get_base1(prev_denom, 1, "prev_denom", 1), 0)) && primitive_value((primitive_value(logical_gt(get_base1(prev_num, 1, "prev_num", 1), 0)) || primitive_value(prev_zero)))))) {
                    current_statement_begin__ = 218;
                    stan::model::assign(prev_prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                get_base1(prevzero, 1, "prevzero", 1), 
                                "assigning variable prev_prob");
                } else {
                    current_statement_begin__ = 219;
                    stan::model::assign(prev_prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable prev_prob");
                }
            }
            current_statement_begin__ = 222;
            if (as_bool(increasing_cf)) {
                current_statement_begin__ = 224;
                for (int a = 1; a <= (eqage - 1); ++a) {
                    current_statement_begin__ = 225;
                    stan::model::assign(cf, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                get_base1(cfbase, 1, "cfbase", 1), 
                                "assigning variable cf");
                }
                current_statement_begin__ = 227;
                if (as_bool(logical_negation(const_cf))) {
                    current_statement_begin__ = 228;
                    stan::math::assign(dcf, stan::math::exp(multiply(X, beta)));
                } else {
                    current_statement_begin__ = 229;
                    stan::math::assign(dcf, rep_vector(0, nage));
                }
                current_statement_begin__ = 230;
                for (int a = eqage; a <= nage; ++a) {
                    current_statement_begin__ = 231;
                    stan::model::assign(cf, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                (get_base1(cf, (a - 1), "cf", 1) + get_base1(dcf, a, "dcf", 1)), 
                                "assigning variable cf");
                }
            } else {
                current_statement_begin__ = 234;
                if (as_bool(smooth_cf)) {
                    current_statement_begin__ = 234;
                    stan::math::assign(cf, stan::math::exp(multiply(X, beta)));
                } else {
                    current_statement_begin__ = 234;
                    stan::math::assign(cf, cf_par);
                }
            }
            current_statement_begin__ = 237;
            if (as_bool(trend)) {
                current_statement_begin__ = 239;
                stan::math::assign(cf, stan::math::exp(multiply(X, beta)));
                current_statement_begin__ = 240;
                for (int b = 1; b <= nyr; ++b) {
                    current_statement_begin__ = 241;
                    stan::model::assign(cf_yr, 
                                stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(b), stan::model::nil_index_list())), 
                                elt_multiply(cf, stan::model::rvalue(cf_trend, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(b), stan::model::nil_index_list())), "cf_trend")), 
                                "assigning variable cf_yr");
                }
                current_statement_begin__ = 243;
                for (int k = 1; k <= nbias; ++k) {
                    current_statement_begin__ = 244;
                    for (int b = 1; b <= nyr; ++b) {
                        current_statement_begin__ = 245;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 246;
                            stan::model::assign(inc_yr, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                        (get_base1(inc, a, k, "inc", 1) * get_base1(inc_trend, a, b, "inc_trend", 1)), 
                                        "assigning variable inc_yr");
                        }
                    }
                    current_statement_begin__ = 250;
                    for (int b = 1; b <= nyr; ++b) {
                        current_statement_begin__ = 251;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())))), 
                                    1, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 252;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())))), 
                                    0, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 253;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())))), 
                                    0, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 256;
                        for (int a = 2; a <= (nage + 1); ++a) {
                            current_statement_begin__ = 257;
                            stan::model::assign(state_probs_yr, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                        rep_row_vector(0, 3), 
                                        "assigning variable state_probs_yr");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 262;
                for (int k = 1; k <= nbias; ++k) {
                    current_statement_begin__ = 263;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()))), 
                                1, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 264;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 265;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()))), 
                                0, 
                                "assigning variable state_probs");
                }
            }
            current_statement_begin__ = 269;
            for (int a = 1; a <= nage; ++a) {
                current_statement_begin__ = 270;
                if (as_bool(trend)) {
                    current_statement_begin__ = 271;
                    for (int k = 1; k <= nbias; ++k) {
                        current_statement_begin__ = 272;
                        if (as_bool(logical_gt(a, 1))) {
                            {
                            current_statement_begin__ = 273;
                            int y(0);
                            (void) y;  // dummy to suppress unused var warning
                            stan::math::fill(y, std::numeric_limits<int>::min());
                            current_statement_begin__ = 274;
                            for (int b = 2; b <= a; ++b) {
                                current_statement_begin__ = 275;
                                stan::math::assign(y, ((nyr - a) + b));
                                current_statement_begin__ = 276;
                                stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc_yr, (b - 1), "inc_yr", 1), (y - 1), "inc_yr", 2), k, "inc_yr", 3), get_base1(cf_yr, (b - 1), (y - 1), "cf_yr", 1), get_base1(rem, (b - 1), "rem", 1), pstream__));
                                current_statement_begin__ = 277;
                                stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs_yr, stan::model::cons_list(stan::model::index_uni((b - 1)), stan::model::cons_list(stan::model::index_uni((y - 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), "state_probs_yr"), P));
                                current_statement_begin__ = 278;
                                stan::model::assign(state_probs_yr, 
                                            stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(y), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                            tmp, 
                                            "assigning variable state_probs_yr");
                            }
                            }
                        }
                        current_statement_begin__ = 282;
                        stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc_yr, a, "inc_yr", 1), nyr, "inc_yr", 2), k, "inc_yr", 3), get_base1(cf_yr, a, nyr, "cf_yr", 1), get_base1(rem, a, "rem", 1), pstream__));
                        current_statement_begin__ = 283;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 284;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 2, "state_probs_yr", 4) / (get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 1, "state_probs_yr", 4) + get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 2, "state_probs_yr", 4))), 
                                    "assigning variable prev_prob");
                        current_statement_begin__ = 286;
                        if (as_bool(logical_eq(k, 1))) {
                            current_statement_begin__ = 286;
                            stan::model::assign(mort_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(prev_prob, a, 1, "prev_prob", 1))) + (get_base1(P, 2, 3, "P", 1) * get_base1(prev_prob, a, 1, "prev_prob", 1))), 
                                        "assigning variable mort_prob");
                        }
                        current_statement_begin__ = 287;
                        stan::model::assign(cf_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                    bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                    "assigning variable cf_prob");
                    }
                } else {
                    current_statement_begin__ = 291;
                    for (int k = 1; k <= nbias; ++k) {
                        current_statement_begin__ = 292;
                        stan::math::assign(P, trans_probs(get_base1(inc, a, k, "inc", 1), get_base1(cf, a, "cf", 1), get_base1(rem, a, "rem", 1), pstream__));
                        current_statement_begin__ = 293;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 294;
                        if (as_bool(logical_gt(a, 1))) {
                            current_statement_begin__ = 295;
                            stan::model::assign(prev_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 2, "state_probs", 3) / (get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 1, "state_probs", 3) + get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 2, "state_probs", 3))), 
                                        "assigning variable prev_prob");
                        }
                        current_statement_begin__ = 296;
                        stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list()))), "state_probs"), P));
                        current_statement_begin__ = 297;
                        stan::model::assign(state_probs, 
                                    stan::model::cons_list(stan::model::index_uni((a + 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list()))), 
                                    tmp, 
                                    "assigning variable state_probs");
                        current_statement_begin__ = 298;
                        if (as_bool(logical_eq(k, 1))) {
                            current_statement_begin__ = 299;
                            stan::model::assign(mort_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(prev_prob, a, 1, "prev_prob", 1))) + (get_base1(P, 2, 3, "P", 1) * get_base1(prev_prob, a, 1, "prev_prob", 1))), 
                                        "assigning variable mort_prob");
                            current_statement_begin__ = 300;
                            stan::model::assign(cf_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                        "assigning variable cf_prob");
                            current_statement_begin__ = 301;
                            if (as_bool(remission)) {
                                current_statement_begin__ = 302;
                                stan::model::assign(rem_prob, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                            get_base1(P, 2, 1, "P", 1), 
                                            "assigning variable rem_prob");
                            }
                        }
                    }
                }
                current_statement_begin__ = 308;
                stan::model::assign(mort_prob, 
                            stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                            bound_prob(get_base1(mort_prob, a, "mort_prob", 1), pstream__), 
                            "assigning variable mort_prob");
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 175;
            size_t cf_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(cf(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cf" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "cf", cf, 0);
            current_statement_begin__ = 176;
            size_t dcf_j_1_max__ = (nage * increasing_cf);
            for (size_t j_1__ = 0; j_1__ < dcf_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(dcf(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: dcf" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable dcf: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "dcf", dcf, 0);
            current_statement_begin__ = 177;
            size_t inc_j_1_max__ = nage;
            size_t inc_j_2_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < inc_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < inc_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(inc(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: inc" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inc: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "inc", inc, 0);
            current_statement_begin__ = 178;
            size_t inc_prob_j_1_max__ = nage;
            size_t inc_prob_j_2_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < inc_prob_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < inc_prob_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(inc_prob(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: inc_prob" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inc_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "inc_prob", inc_prob, 0);
            check_less_or_equal(function__, "inc_prob", inc_prob, 1);
            current_statement_begin__ = 179;
            size_t rem_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < rem_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(rem(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rem" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rem: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "rem", rem, 0);
            current_statement_begin__ = 180;
            size_t rem_prob_j_1_max__ = (nage * remission);
            for (size_t j_1__ = 0; j_1__ < rem_prob_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(rem_prob(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: rem_prob" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rem_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "rem_prob", rem_prob, 0);
            check_less_or_equal(function__, "rem_prob", rem_prob, 1);
            current_statement_begin__ = 181;
            size_t cf_prob_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_prob_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(cf_prob(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: cf_prob" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cf_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "cf_prob", cf_prob, 0);
            check_less_or_equal(function__, "cf_prob", cf_prob, 1);
            current_statement_begin__ = 183;
            size_t state_probs_k_0_max__ = ((nage + 1) * (1 - trend));
            size_t state_probs_k_1_max__ = nbias;
            size_t state_probs_j_1_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                    for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                        if (stan::math::is_uninitialized(state_probs[k_0__][k_1__](j_1__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: state_probs" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "(" << j_1__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable state_probs: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 184;
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(tmp(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: tmp" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable tmp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 185;
            size_t P_j_1_max__ = 3;
            size_t P_j_2_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(P(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: P" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable P: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "P", P, 0);
            check_less_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 186;
            size_t prev_prob_j_1_max__ = nage;
            size_t prev_prob_j_2_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < prev_prob_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < prev_prob_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(prev_prob(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: prev_prob" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable prev_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "prev_prob", prev_prob, 0);
            current_statement_begin__ = 187;
            size_t mort_prob_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(mort_prob[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: mort_prob" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mort_prob: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            size_t mort_prob_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < mort_prob_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mort_prob[i_0__]", mort_prob[i_0__], 0);
            }
            current_statement_begin__ = 189;
            size_t cf_yr_j_1_max__ = (nage * trend);
            size_t cf_yr_j_2_max__ = (nyr * trend);
            for (size_t j_1__ = 0; j_1__ < cf_yr_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < cf_yr_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(cf_yr(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: cf_yr" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable cf_yr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            check_greater_or_equal(function__, "cf_yr", cf_yr, 0);
            current_statement_begin__ = 190;
            size_t inc_yr_k_0_max__ = (nage * trend);
            size_t inc_yr_k_1_max__ = (nyr * trend);
            size_t inc_yr_k_2_max__ = nbias;
            for (size_t k_0__ = 0; k_0__ < inc_yr_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < inc_yr_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < inc_yr_k_2_max__; ++k_2__) {
                        if (stan::math::is_uninitialized(inc_yr[k_0__][k_1__][k_2__])) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: inc_yr" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable inc_yr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t inc_yr_i_0_max__ = (nage * trend);
            size_t inc_yr_i_1_max__ = (nyr * trend);
            size_t inc_yr_i_2_max__ = nbias;
            for (size_t i_0__ = 0; i_0__ < inc_yr_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_yr_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_yr_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_yr[i_0__][i_1__][i_2__]", inc_yr[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 191;
            size_t state_probs_yr_k_0_max__ = ((nage + 1) * trend);
            size_t state_probs_yr_k_1_max__ = (nyr * trend);
            size_t state_probs_yr_k_2_max__ = nbias;
            size_t state_probs_yr_j_1_max__ = 3;
            for (size_t k_0__ = 0; k_0__ < state_probs_yr_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < state_probs_yr_k_1_max__; ++k_1__) {
                    for (size_t k_2__ = 0; k_2__ < state_probs_yr_k_2_max__; ++k_2__) {
                        for (size_t j_1__ = 0; j_1__ < state_probs_yr_j_1_max__; ++j_1__) {
                            if (stan::math::is_uninitialized(state_probs_yr[k_0__][k_1__][k_2__](j_1__))) {
                                std::stringstream msg__;
                                msg__ << "Undefined transformed parameter: state_probs_yr" << "[" << k_0__ << "]" << "[" << k_1__ << "]" << "[" << k_2__ << "]" << "(" << j_1__ << ")";
                                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable state_probs_yr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                            }
                        }
                    }
                }
            }
            current_statement_begin__ = 193;
            if (stan::math::is_uninitialized(lambda_cf_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_cf_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_cf_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_cf_use", lambda_cf_use, 0);
            current_statement_begin__ = 194;
            if (stan::math::is_uninitialized(lambda_inc_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_inc_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_inc_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_inc_use", lambda_inc_use, 0);
            current_statement_begin__ = 195;
            if (stan::math::is_uninitialized(lambda_rem_use)) {
                std::stringstream msg__;
                msg__ << "Undefined transformed parameter: lambda_rem_use";
                stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable lambda_rem_use: ") + msg__.str()), current_statement_begin__, prog_reader__());
            }
            check_greater_or_equal(function__, "lambda_rem_use", lambda_rem_use, 0);
            // model body
            current_statement_begin__ = 313;
            lp_accum__.add(binomial_log<propto__>(mort_num, mort_denom, mort_prob));
            current_statement_begin__ = 314;
            lp_accum__.add(binomial_log<propto__>(inc_num, inc_denom, stan::model::rvalue(inc_prob, stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(incdata_ind), stan::model::nil_index_list())), "inc_prob")));
            current_statement_begin__ = 315;
            lp_accum__.add(binomial_log<propto__>(prev_num, prev_denom, stan::model::rvalue(prev_prob, stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(prevdata_ind), stan::model::nil_index_list())), "prev_prob")));
            current_statement_begin__ = 316;
            if (as_bool(remission)) {
                current_statement_begin__ = 317;
                lp_accum__.add(binomial_log<propto__>(rem_num, rem_denom, rem_prob));
            }
            current_statement_begin__ = 320;
            if (as_bool(smooth_cf)) {
                current_statement_begin__ = 321;
                if (as_bool(logical_negation(const_cf))) {
                    current_statement_begin__ = 322;
                    for (int i = 1; i <= (K - 2); ++i) {
                        current_statement_begin__ = 323;
                        lp_accum__.add(normal_log<propto__>(get_base1(beta, i, "beta", 1), 0, lambda_cf_use));
                    }
                    current_statement_begin__ = 325;
                    for (int i = (K - 1); i <= K; ++i) {
                        current_statement_begin__ = 326;
                        lp_accum__.add(normal_log<propto__>(get_base1(beta, i, "beta", 1), 0, 100));
                    }
                }
                current_statement_begin__ = 329;
                if (as_bool(logical_negation(scf_isfixed))) {
                    current_statement_begin__ = 330;
                    lp_accum__.add(gamma_log<propto__>(get_base1(lambda_cf, 1, "lambda_cf", 1), 2, get_base1(sprior, 2, "sprior", 1)));
                }
            } else {
                current_statement_begin__ = 333;
                for (int a = 1; a <= nage; ++a) {
                    current_statement_begin__ = 334;
                    lp_accum__.add(gamma_log<propto__>(get_base1(cf_par, a, "cf_par", 1), get_base1(cf_prior, 1, "cf_prior", 1), get_base1(cf_prior, 2, "cf_prior", 1)));
                }
            }
            current_statement_begin__ = 337;
            if (as_bool(increasing_cf)) {
                current_statement_begin__ = 338;
                lp_accum__.add(gamma_log<propto__>(get_base1(cfbase, 1, "cfbase", 1), get_base1(cf_prior, 1, "cf_prior", 1), get_base1(cf_prior, 2, "cf_prior", 1)));
            }
            current_statement_begin__ = 341;
            if (as_bool(smooth_inc)) {
                current_statement_begin__ = 342;
                for (int i = 1; i <= (K - 2); ++i) {
                    current_statement_begin__ = 343;
                    lp_accum__.add(normal_log<propto__>(get_base1(beta_inc, i, "beta_inc", 1), 0, lambda_inc_use));
                }
                current_statement_begin__ = 345;
                for (int i = (K - 1); i <= K; ++i) {
                    current_statement_begin__ = 346;
                    lp_accum__.add(normal_log<propto__>(get_base1(beta_inc, i, "beta_inc", 1), 0, 100));
                }
                current_statement_begin__ = 348;
                if (as_bool(logical_negation(sinc_isfixed))) {
                    current_statement_begin__ = 349;
                    lp_accum__.add(gamma_log<propto__>(get_base1(lambda_inc, 1, "lambda_inc", 1), 2, get_base1(sprior, 1, "sprior", 1)));
                }
            } else {
                current_statement_begin__ = 352;
                for (int a = 1; a <= nage; ++a) {
                    current_statement_begin__ = 353;
                    lp_accum__.add(gamma_log<propto__>(get_base1(inc_par, a, "inc_par", 1), get_base1(inc_prior, 1, "inc_prior", 1), get_base1(inc_prior, 2, "inc_prior", 1)));
                }
            }
            current_statement_begin__ = 357;
            if (as_bool(remission)) {
                current_statement_begin__ = 358;
                if (as_bool(smooth_rem)) {
                    current_statement_begin__ = 359;
                    for (int i = 1; i <= (K - 2); ++i) {
                        current_statement_begin__ = 360;
                        lp_accum__.add(normal_log<propto__>(get_base1(beta_rem, i, "beta_rem", 1), 0, lambda_rem_use));
                    }
                    current_statement_begin__ = 362;
                    for (int i = (K - 1); i <= K; ++i) {
                        current_statement_begin__ = 363;
                        lp_accum__.add(normal_log<propto__>(get_base1(beta_rem, i, "beta_rem", 1), 0, 100));
                    }
                    current_statement_begin__ = 365;
                    if (as_bool(logical_negation(srem_isfixed))) {
                        current_statement_begin__ = 366;
                        lp_accum__.add(gamma_log<propto__>(get_base1(lambda_rem, 1, "lambda_rem", 1), 2, get_base1(sprior, 3, "sprior", 1)));
                    }
                } else if (as_bool(const_rem)) {
                    current_statement_begin__ = 367;
                    lp_accum__.add(gamma_log<propto__>(get_base1(rem_par, 1, "rem_par", 1), get_base1(rem_prior, 1, "rem_prior", 1), get_base1(rem_prior, 2, "rem_prior", 1)));
                } else {
                    current_statement_begin__ = 369;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 370;
                        lp_accum__.add(gamma_log<propto__>(get_base1(rem_par, a, "rem_par", 1), get_base1(rem_prior, 1, "rem_prior", 1), get_base1(rem_prior, 2, "rem_prior", 1)));
                    }
                }
            }
            current_statement_begin__ = 375;
            if (as_bool(logical_eq(nbias, 2))) {
                current_statement_begin__ = 376;
                lp_accum__.add(normal_log<propto__>(bias_loghr, 0, 1));
            }
            current_statement_begin__ = 379;
            if (as_bool(prev_zero)) {
                current_statement_begin__ = 380;
                lp_accum__.add(beta_log<propto__>(get_base1(prevzero, 1, "prevzero", 1), 2, 2));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("inc_par");
        names__.push_back("cf_par");
        names__.push_back("rem_par");
        names__.push_back("beta");
        names__.push_back("lambda_cf");
        names__.push_back("lambda_inc");
        names__.push_back("beta_inc");
        names__.push_back("lambda_rem");
        names__.push_back("beta_rem");
        names__.push_back("prevzero");
        names__.push_back("bias_loghr");
        names__.push_back("cfbase");
        names__.push_back("cf");
        names__.push_back("dcf");
        names__.push_back("inc");
        names__.push_back("inc_prob");
        names__.push_back("rem");
        names__.push_back("rem_prob");
        names__.push_back("cf_prob");
        names__.push_back("state_probs");
        names__.push_back("tmp");
        names__.push_back("P");
        names__.push_back("prev_prob");
        names__.push_back("mort_prob");
        names__.push_back("cf_yr");
        names__.push_back("inc_yr");
        names__.push_back("state_probs_yr");
        names__.push_back("lambda_cf_use");
        names__.push_back("lambda_inc_use");
        names__.push_back("lambda_rem_use");
        names__.push_back("ll_mort");
        names__.push_back("ll_inc");
        names__.push_back("ll_prev");
        names__.push_back("ll_rem");
        names__.push_back("ll_overall");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back((nage * (1 - smooth_inc)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * (1 - smooth_cf)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((K * smooth_cf) * (1 - const_cf)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((smooth_cf * (1 - scf_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((smooth_inc * (1 - sinc_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * smooth_inc));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((smooth_rem * (1 - srem_isfixed)));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((K * smooth_rem));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(prev_zero);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(logical_eq(nbias, 2));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((1 * increasing_cf));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * increasing_cf));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(nbias);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(nbias);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * remission));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((nage + 1) * (1 - trend)));
        dims__.push_back(nbias);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(3);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dims__.push_back(nbias);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * trend));
        dims__.push_back((nyr * trend));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * trend));
        dims__.push_back((nyr * trend));
        dims__.push_back(nbias);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(((nage + 1) * trend));
        dims__.push_back((nyr * trend));
        dims__.push_back(nbias);
        dims__.push_back(3);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nage);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * inc_supplied));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * prev_supplied));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * remission));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nage * (((1 + inc_supplied) + prev_supplied) + remission)));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_disbayes_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> inc_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_inc)));
        size_t inc_par_j_1_max__ = (nage * (1 - smooth_inc));
        for (size_t j_1__ = 0; j_1__ < inc_par_j_1_max__; ++j_1__) {
            vars__.push_back(inc_par(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> cf_par = in__.vector_lb_constrain(0, (nage * (1 - smooth_cf)));
        size_t cf_par_j_1_max__ = (nage * (1 - smooth_cf));
        for (size_t j_1__ = 0; j_1__ < cf_par_j_1_max__; ++j_1__) {
            vars__.push_back(cf_par(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> rem_par = in__.vector_lb_constrain(0, ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem))));
        size_t rem_par_j_1_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        for (size_t j_1__ = 0; j_1__ < rem_par_j_1_max__; ++j_1__) {
            vars__.push_back(rem_par(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta = in__.vector_constrain(((K * smooth_cf) * (1 - const_cf)));
        size_t beta_j_1_max__ = ((K * smooth_cf) * (1 - const_cf));
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            vars__.push_back(beta(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_cf = in__.vector_lb_constrain(0, (smooth_cf * (1 - scf_isfixed)));
        size_t lambda_cf_j_1_max__ = (smooth_cf * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_cf(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_inc = in__.vector_lb_constrain(0, (smooth_inc * (1 - sinc_isfixed)));
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_inc(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_inc = in__.vector_constrain((K * smooth_inc));
        size_t beta_inc_j_1_max__ = (K * smooth_inc);
        for (size_t j_1__ = 0; j_1__ < beta_inc_j_1_max__; ++j_1__) {
            vars__.push_back(beta_inc(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rem = in__.vector_lb_constrain(0, (smooth_rem * (1 - srem_isfixed)));
        size_t lambda_rem_j_1_max__ = (smooth_rem * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_rem(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta_rem = in__.vector_constrain((K * smooth_rem));
        size_t beta_rem_j_1_max__ = (K * smooth_rem);
        for (size_t j_1__ = 0; j_1__ < beta_rem_j_1_max__; ++j_1__) {
            vars__.push_back(beta_rem(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> prevzero = in__.vector_lub_constrain(0, 1, prev_zero);
        size_t prevzero_j_1_max__ = prev_zero;
        for (size_t j_1__ = 0; j_1__ < prevzero_j_1_max__; ++j_1__) {
            vars__.push_back(prevzero(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> bias_loghr = in__.vector_constrain(logical_eq(nbias, 2));
        size_t bias_loghr_j_1_max__ = logical_eq(nbias, 2);
        for (size_t j_1__ = 0; j_1__ < bias_loghr_j_1_max__; ++j_1__) {
            vars__.push_back(bias_loghr(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> cfbase = in__.vector_lb_constrain(0, (1 * increasing_cf));
        size_t cfbase_j_1_max__ = (1 * increasing_cf);
        for (size_t j_1__ = 0; j_1__ < cfbase_j_1_max__; ++j_1__) {
            vars__.push_back(cfbase(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 175;
            validate_non_negative_index("cf", "nage", nage);
            Eigen::Matrix<double, Eigen::Dynamic, 1> cf(nage);
            stan::math::initialize(cf, DUMMY_VAR__);
            stan::math::fill(cf, DUMMY_VAR__);
            current_statement_begin__ = 176;
            validate_non_negative_index("dcf", "(nage * increasing_cf)", (nage * increasing_cf));
            Eigen::Matrix<double, Eigen::Dynamic, 1> dcf((nage * increasing_cf));
            stan::math::initialize(dcf, DUMMY_VAR__);
            stan::math::fill(dcf, DUMMY_VAR__);
            current_statement_begin__ = 177;
            validate_non_negative_index("inc", "nage", nage);
            validate_non_negative_index("inc", "nbias", nbias);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> inc(nage, nbias);
            stan::math::initialize(inc, DUMMY_VAR__);
            stan::math::fill(inc, DUMMY_VAR__);
            current_statement_begin__ = 178;
            validate_non_negative_index("inc_prob", "nage", nage);
            validate_non_negative_index("inc_prob", "nbias", nbias);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> inc_prob(nage, nbias);
            stan::math::initialize(inc_prob, DUMMY_VAR__);
            stan::math::fill(inc_prob, DUMMY_VAR__);
            current_statement_begin__ = 179;
            validate_non_negative_index("rem", "nage", nage);
            Eigen::Matrix<double, Eigen::Dynamic, 1> rem(nage);
            stan::math::initialize(rem, DUMMY_VAR__);
            stan::math::fill(rem, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("rem_prob", "(nage * remission)", (nage * remission));
            Eigen::Matrix<double, Eigen::Dynamic, 1> rem_prob((nage * remission));
            stan::math::initialize(rem_prob, DUMMY_VAR__);
            stan::math::fill(rem_prob, DUMMY_VAR__);
            current_statement_begin__ = 181;
            validate_non_negative_index("cf_prob", "nage", nage);
            Eigen::Matrix<double, Eigen::Dynamic, 1> cf_prob(nage);
            stan::math::initialize(cf_prob, DUMMY_VAR__);
            stan::math::fill(cf_prob, DUMMY_VAR__);
            current_statement_begin__ = 183;
            validate_non_negative_index("state_probs", "3", 3);
            validate_non_negative_index("state_probs", "((nage + 1) * (1 - trend))", ((nage + 1) * (1 - trend)));
            validate_non_negative_index("state_probs", "nbias", nbias);
            std::vector<std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > > state_probs(((nage + 1) * (1 - trend)), std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(nbias, Eigen::Matrix<double, 1, Eigen::Dynamic>(3)));
            stan::math::initialize(state_probs, DUMMY_VAR__);
            stan::math::fill(state_probs, DUMMY_VAR__);
            current_statement_begin__ = 184;
            validate_non_negative_index("tmp", "3", 3);
            Eigen::Matrix<double, 1, Eigen::Dynamic> tmp(3);
            stan::math::initialize(tmp, DUMMY_VAR__);
            stan::math::fill(tmp, DUMMY_VAR__);
            current_statement_begin__ = 185;
            validate_non_negative_index("P", "3", 3);
            validate_non_negative_index("P", "3", 3);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> P(3, 3);
            stan::math::initialize(P, DUMMY_VAR__);
            stan::math::fill(P, DUMMY_VAR__);
            current_statement_begin__ = 186;
            validate_non_negative_index("prev_prob", "nage", nage);
            validate_non_negative_index("prev_prob", "nbias", nbias);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> prev_prob(nage, nbias);
            stan::math::initialize(prev_prob, DUMMY_VAR__);
            stan::math::fill(prev_prob, DUMMY_VAR__);
            current_statement_begin__ = 187;
            validate_non_negative_index("mort_prob", "nage", nage);
            std::vector<double> mort_prob(nage, double(0));
            stan::math::initialize(mort_prob, DUMMY_VAR__);
            stan::math::fill(mort_prob, DUMMY_VAR__);
            current_statement_begin__ = 189;
            validate_non_negative_index("cf_yr", "(nage * trend)", (nage * trend));
            validate_non_negative_index("cf_yr", "(nyr * trend)", (nyr * trend));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> cf_yr((nage * trend), (nyr * trend));
            stan::math::initialize(cf_yr, DUMMY_VAR__);
            stan::math::fill(cf_yr, DUMMY_VAR__);
            current_statement_begin__ = 190;
            validate_non_negative_index("inc_yr", "(nage * trend)", (nage * trend));
            validate_non_negative_index("inc_yr", "(nyr * trend)", (nyr * trend));
            validate_non_negative_index("inc_yr", "nbias", nbias);
            std::vector<std::vector<std::vector<double> > > inc_yr((nage * trend), std::vector<std::vector<double> >((nyr * trend), std::vector<double>(nbias, double(0))));
            stan::math::initialize(inc_yr, DUMMY_VAR__);
            stan::math::fill(inc_yr, DUMMY_VAR__);
            current_statement_begin__ = 191;
            validate_non_negative_index("state_probs_yr", "3", 3);
            validate_non_negative_index("state_probs_yr", "((nage + 1) * trend)", ((nage + 1) * trend));
            validate_non_negative_index("state_probs_yr", "(nyr * trend)", (nyr * trend));
            validate_non_negative_index("state_probs_yr", "nbias", nbias);
            std::vector<std::vector<std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > > > state_probs_yr(((nage + 1) * trend), std::vector<std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> > >((nyr * trend), std::vector<Eigen::Matrix<double, 1, Eigen::Dynamic> >(nbias, Eigen::Matrix<double, 1, Eigen::Dynamic>(3))));
            stan::math::initialize(state_probs_yr, DUMMY_VAR__);
            stan::math::fill(state_probs_yr, DUMMY_VAR__);
            current_statement_begin__ = 193;
            double lambda_cf_use;
            (void) lambda_cf_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_cf_use, DUMMY_VAR__);
            stan::math::fill(lambda_cf_use, DUMMY_VAR__);
            current_statement_begin__ = 194;
            double lambda_inc_use;
            (void) lambda_inc_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_inc_use, DUMMY_VAR__);
            stan::math::fill(lambda_inc_use, DUMMY_VAR__);
            current_statement_begin__ = 195;
            double lambda_rem_use;
            (void) lambda_rem_use;  // dummy to suppress unused var warning
            stan::math::initialize(lambda_rem_use, DUMMY_VAR__);
            stan::math::fill(lambda_rem_use, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 196;
            if (as_bool((primitive_value(scf_isfixed) || primitive_value(logical_negation(smooth_cf))))) {
                current_statement_begin__ = 196;
                stan::math::assign(lambda_cf_use, lambda_cf_fixed);
            } else {
                current_statement_begin__ = 196;
                stan::math::assign(lambda_cf_use, get_base1(lambda_cf, 1, "lambda_cf", 1));
            }
            current_statement_begin__ = 197;
            if (as_bool((primitive_value(sinc_isfixed) || primitive_value(logical_negation(smooth_inc))))) {
                current_statement_begin__ = 197;
                stan::math::assign(lambda_inc_use, lambda_inc_fixed);
            } else {
                current_statement_begin__ = 197;
                stan::math::assign(lambda_inc_use, get_base1(lambda_inc, 1, "lambda_inc", 1));
            }
            current_statement_begin__ = 198;
            if (as_bool((primitive_value(srem_isfixed) || primitive_value(logical_negation(smooth_rem))))) {
                current_statement_begin__ = 198;
                stan::math::assign(lambda_rem_use, lambda_rem_fixed);
            } else {
                current_statement_begin__ = 198;
                stan::math::assign(lambda_rem_use, get_base1(lambda_rem, 1, "lambda_rem", 1));
            }
            current_statement_begin__ = 202;
            if (as_bool(smooth_inc)) {
                current_statement_begin__ = 202;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            stan::math::exp(multiply(X, beta_inc)), 
                            "assigning variable inc");
            } else {
                current_statement_begin__ = 202;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            inc_par, 
                            "assigning variable inc");
            }
            current_statement_begin__ = 203;
            if (as_bool(logical_gt(nbias, 1))) {
                current_statement_begin__ = 204;
                stan::model::assign(inc, 
                            stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                            stan::model::deep_copy(stan::math::exp(add(stan::math::log(stan::model::rvalue(inc, stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), "inc")), get_base1(bias_loghr, 1, "bias_loghr", 1)))), 
                            "assigning variable inc");
            }
            current_statement_begin__ = 206;
            if (as_bool(remission)) {
                current_statement_begin__ = 207;
                if (as_bool(const_rem)) {
                    current_statement_begin__ = 208;
                    for (int a = 1; a <= nage; ++a) {
                        current_statement_begin__ = 209;
                        stan::model::assign(rem, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                    get_base1(rem_par, 1, "rem_par", 1), 
                                    "assigning variable rem");
                    }
                } else if (as_bool(smooth_rem)) {
                    current_statement_begin__ = 211;
                    stan::math::assign(rem, stan::math::exp(multiply(X, beta_rem)));
                } else {
                    current_statement_begin__ = 212;
                    stan::math::assign(rem, rem_par);
                }
            } else {
                current_statement_begin__ = 213;
                stan::math::assign(rem, rep_vector(0, nage));
            }
            current_statement_begin__ = 216;
            for (int k = 1; k <= nbias; ++k) {
                current_statement_begin__ = 217;
                if (as_bool((primitive_value(logical_gt(get_base1(prev_denom, 1, "prev_denom", 1), 0)) && primitive_value((primitive_value(logical_gt(get_base1(prev_num, 1, "prev_num", 1), 0)) || primitive_value(prev_zero)))))) {
                    current_statement_begin__ = 218;
                    stan::model::assign(prev_prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                get_base1(prevzero, 1, "prevzero", 1), 
                                "assigning variable prev_prob");
                } else {
                    current_statement_begin__ = 219;
                    stan::model::assign(prev_prob, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                0, 
                                "assigning variable prev_prob");
                }
            }
            current_statement_begin__ = 222;
            if (as_bool(increasing_cf)) {
                current_statement_begin__ = 224;
                for (int a = 1; a <= (eqage - 1); ++a) {
                    current_statement_begin__ = 225;
                    stan::model::assign(cf, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                get_base1(cfbase, 1, "cfbase", 1), 
                                "assigning variable cf");
                }
                current_statement_begin__ = 227;
                if (as_bool(logical_negation(const_cf))) {
                    current_statement_begin__ = 228;
                    stan::math::assign(dcf, stan::math::exp(multiply(X, beta)));
                } else {
                    current_statement_begin__ = 229;
                    stan::math::assign(dcf, rep_vector(0, nage));
                }
                current_statement_begin__ = 230;
                for (int a = eqage; a <= nage; ++a) {
                    current_statement_begin__ = 231;
                    stan::model::assign(cf, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                (get_base1(cf, (a - 1), "cf", 1) + get_base1(dcf, a, "dcf", 1)), 
                                "assigning variable cf");
                }
            } else {
                current_statement_begin__ = 234;
                if (as_bool(smooth_cf)) {
                    current_statement_begin__ = 234;
                    stan::math::assign(cf, stan::math::exp(multiply(X, beta)));
                } else {
                    current_statement_begin__ = 234;
                    stan::math::assign(cf, cf_par);
                }
            }
            current_statement_begin__ = 237;
            if (as_bool(trend)) {
                current_statement_begin__ = 239;
                stan::math::assign(cf, stan::math::exp(multiply(X, beta)));
                current_statement_begin__ = 240;
                for (int b = 1; b <= nyr; ++b) {
                    current_statement_begin__ = 241;
                    stan::model::assign(cf_yr, 
                                stan::model::cons_list(stan::model::index_min_max(1, nage), stan::model::cons_list(stan::model::index_uni(b), stan::model::nil_index_list())), 
                                elt_multiply(cf, stan::model::rvalue(cf_trend, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(b), stan::model::nil_index_list())), "cf_trend")), 
                                "assigning variable cf_yr");
                }
                current_statement_begin__ = 243;
                for (int k = 1; k <= nbias; ++k) {
                    current_statement_begin__ = 244;
                    for (int b = 1; b <= nyr; ++b) {
                        current_statement_begin__ = 245;
                        for (int a = 1; a <= nage; ++a) {
                            current_statement_begin__ = 246;
                            stan::model::assign(inc_yr, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list()))), 
                                        (get_base1(inc, a, k, "inc", 1) * get_base1(inc_trend, a, b, "inc_trend", 1)), 
                                        "assigning variable inc_yr");
                        }
                    }
                    current_statement_begin__ = 250;
                    for (int b = 1; b <= nyr; ++b) {
                        current_statement_begin__ = 251;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())))), 
                                    1, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 252;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())))), 
                                    0, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 253;
                        stan::model::assign(state_probs_yr, 
                                    stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list())))), 
                                    0, 
                                    "assigning variable state_probs_yr");
                        current_statement_begin__ = 256;
                        for (int a = 2; a <= (nage + 1); ++a) {
                            current_statement_begin__ = 257;
                            stan::model::assign(state_probs_yr, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                        rep_row_vector(0, 3), 
                                        "assigning variable state_probs_yr");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 262;
                for (int k = 1; k <= nbias; ++k) {
                    current_statement_begin__ = 263;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()))), 
                                1, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 264;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()))), 
                                0, 
                                "assigning variable state_probs");
                    current_statement_begin__ = 265;
                    stan::model::assign(state_probs, 
                                stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()))), 
                                0, 
                                "assigning variable state_probs");
                }
            }
            current_statement_begin__ = 269;
            for (int a = 1; a <= nage; ++a) {
                current_statement_begin__ = 270;
                if (as_bool(trend)) {
                    current_statement_begin__ = 271;
                    for (int k = 1; k <= nbias; ++k) {
                        current_statement_begin__ = 272;
                        if (as_bool(logical_gt(a, 1))) {
                            {
                            current_statement_begin__ = 273;
                            int y(0);
                            (void) y;  // dummy to suppress unused var warning
                            stan::math::fill(y, std::numeric_limits<int>::min());
                            current_statement_begin__ = 274;
                            for (int b = 2; b <= a; ++b) {
                                current_statement_begin__ = 275;
                                stan::math::assign(y, ((nyr - a) + b));
                                current_statement_begin__ = 276;
                                stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc_yr, (b - 1), "inc_yr", 1), (y - 1), "inc_yr", 2), k, "inc_yr", 3), get_base1(cf_yr, (b - 1), (y - 1), "cf_yr", 1), get_base1(rem, (b - 1), "rem", 1), pstream__));
                                current_statement_begin__ = 277;
                                stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs_yr, stan::model::cons_list(stan::model::index_uni((b - 1)), stan::model::cons_list(stan::model::index_uni((y - 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), "state_probs_yr"), P));
                                current_statement_begin__ = 278;
                                stan::model::assign(state_probs_yr, 
                                            stan::model::cons_list(stan::model::index_uni(b), stan::model::cons_list(stan::model::index_uni(y), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list())))), 
                                            tmp, 
                                            "assigning variable state_probs_yr");
                            }
                            }
                        }
                        current_statement_begin__ = 282;
                        stan::math::assign(P, trans_probs(get_base1(get_base1(get_base1(inc_yr, a, "inc_yr", 1), nyr, "inc_yr", 2), k, "inc_yr", 3), get_base1(cf_yr, a, nyr, "cf_yr", 1), get_base1(rem, a, "rem", 1), pstream__));
                        current_statement_begin__ = 283;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 284;
                        stan::model::assign(prev_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    (get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 2, "state_probs_yr", 4) / (get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 1, "state_probs_yr", 4) + get_base1(get_base1(get_base1(get_base1(state_probs_yr, a, "state_probs_yr", 1), nyr, "state_probs_yr", 2), k, "state_probs_yr", 3), 2, "state_probs_yr", 4))), 
                                    "assigning variable prev_prob");
                        current_statement_begin__ = 286;
                        if (as_bool(logical_eq(k, 1))) {
                            current_statement_begin__ = 286;
                            stan::model::assign(mort_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(prev_prob, a, 1, "prev_prob", 1))) + (get_base1(P, 2, 3, "P", 1) * get_base1(prev_prob, a, 1, "prev_prob", 1))), 
                                        "assigning variable mort_prob");
                        }
                        current_statement_begin__ = 287;
                        stan::model::assign(cf_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                    bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                    "assigning variable cf_prob");
                    }
                } else {
                    current_statement_begin__ = 291;
                    for (int k = 1; k <= nbias; ++k) {
                        current_statement_begin__ = 292;
                        stan::math::assign(P, trans_probs(get_base1(inc, a, k, "inc", 1), get_base1(cf, a, "cf", 1), get_base1(rem, a, "rem", 1), pstream__));
                        current_statement_begin__ = 293;
                        stan::model::assign(inc_prob, 
                                    stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                    bound_prob((get_base1(P, 1, 2, "P", 1) + get_base1(P, 1, 3, "P", 1)), pstream__), 
                                    "assigning variable inc_prob");
                        current_statement_begin__ = 294;
                        if (as_bool(logical_gt(a, 1))) {
                            current_statement_begin__ = 295;
                            stan::model::assign(prev_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 2, "state_probs", 3) / (get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 1, "state_probs", 3) + get_base1(get_base1(get_base1(state_probs, a, "state_probs", 1), k, "state_probs", 2), 2, "state_probs", 3))), 
                                        "assigning variable prev_prob");
                        }
                        current_statement_begin__ = 296;
                        stan::math::assign(tmp, multiply(stan::model::rvalue(state_probs, stan::model::cons_list(stan::model::index_uni(a), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list()))), "state_probs"), P));
                        current_statement_begin__ = 297;
                        stan::model::assign(state_probs, 
                                    stan::model::cons_list(stan::model::index_uni((a + 1)), stan::model::cons_list(stan::model::index_uni(k), stan::model::cons_list(stan::model::index_min_max(1, 3), stan::model::nil_index_list()))), 
                                    tmp, 
                                    "assigning variable state_probs");
                        current_statement_begin__ = 298;
                        if (as_bool(logical_eq(k, 1))) {
                            current_statement_begin__ = 299;
                            stan::model::assign(mort_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        ((get_base1(P, 1, 3, "P", 1) * (1 - get_base1(prev_prob, a, 1, "prev_prob", 1))) + (get_base1(P, 2, 3, "P", 1) * get_base1(prev_prob, a, 1, "prev_prob", 1))), 
                                        "assigning variable mort_prob");
                            current_statement_begin__ = 300;
                            stan::model::assign(cf_prob, 
                                        stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                        bound_prob(get_base1(P, 2, 3, "P", 1), pstream__), 
                                        "assigning variable cf_prob");
                            current_statement_begin__ = 301;
                            if (as_bool(remission)) {
                                current_statement_begin__ = 302;
                                stan::model::assign(rem_prob, 
                                            stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                            get_base1(P, 2, 1, "P", 1), 
                                            "assigning variable rem_prob");
                            }
                        }
                    }
                }
                current_statement_begin__ = 308;
                stan::model::assign(mort_prob, 
                            stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                            bound_prob(get_base1(mort_prob, a, "mort_prob", 1), pstream__), 
                            "assigning variable mort_prob");
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 175;
            check_greater_or_equal(function__, "cf", cf, 0);
            current_statement_begin__ = 176;
            check_greater_or_equal(function__, "dcf", dcf, 0);
            current_statement_begin__ = 177;
            check_greater_or_equal(function__, "inc", inc, 0);
            current_statement_begin__ = 178;
            check_greater_or_equal(function__, "inc_prob", inc_prob, 0);
            check_less_or_equal(function__, "inc_prob", inc_prob, 1);
            current_statement_begin__ = 179;
            check_greater_or_equal(function__, "rem", rem, 0);
            current_statement_begin__ = 180;
            check_greater_or_equal(function__, "rem_prob", rem_prob, 0);
            check_less_or_equal(function__, "rem_prob", rem_prob, 1);
            current_statement_begin__ = 181;
            check_greater_or_equal(function__, "cf_prob", cf_prob, 0);
            check_less_or_equal(function__, "cf_prob", cf_prob, 1);
            current_statement_begin__ = 185;
            check_greater_or_equal(function__, "P", P, 0);
            check_less_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 186;
            check_greater_or_equal(function__, "prev_prob", prev_prob, 0);
            current_statement_begin__ = 187;
            size_t mort_prob_i_0_max__ = nage;
            for (size_t i_0__ = 0; i_0__ < mort_prob_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "mort_prob[i_0__]", mort_prob[i_0__], 0);
            }
            current_statement_begin__ = 189;
            check_greater_or_equal(function__, "cf_yr", cf_yr, 0);
            current_statement_begin__ = 190;
            size_t inc_yr_i_0_max__ = (nage * trend);
            size_t inc_yr_i_1_max__ = (nyr * trend);
            size_t inc_yr_i_2_max__ = nbias;
            for (size_t i_0__ = 0; i_0__ < inc_yr_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < inc_yr_i_1_max__; ++i_1__) {
                    for (size_t i_2__ = 0; i_2__ < inc_yr_i_2_max__; ++i_2__) {
                        check_greater_or_equal(function__, "inc_yr[i_0__][i_1__][i_2__]", inc_yr[i_0__][i_1__][i_2__], 0);
                    }
                }
            }
            current_statement_begin__ = 193;
            check_greater_or_equal(function__, "lambda_cf_use", lambda_cf_use, 0);
            current_statement_begin__ = 194;
            check_greater_or_equal(function__, "lambda_inc_use", lambda_inc_use, 0);
            current_statement_begin__ = 195;
            check_greater_or_equal(function__, "lambda_rem_use", lambda_rem_use, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t cf_j_1_max__ = nage;
                for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
                    vars__.push_back(cf(j_1__));
                }
                size_t dcf_j_1_max__ = (nage * increasing_cf);
                for (size_t j_1__ = 0; j_1__ < dcf_j_1_max__; ++j_1__) {
                    vars__.push_back(dcf(j_1__));
                }
                size_t inc_j_2_max__ = nbias;
                size_t inc_j_1_max__ = nage;
                for (size_t j_2__ = 0; j_2__ < inc_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < inc_j_1_max__; ++j_1__) {
                        vars__.push_back(inc(j_1__, j_2__));
                    }
                }
                size_t inc_prob_j_2_max__ = nbias;
                size_t inc_prob_j_1_max__ = nage;
                for (size_t j_2__ = 0; j_2__ < inc_prob_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < inc_prob_j_1_max__; ++j_1__) {
                        vars__.push_back(inc_prob(j_1__, j_2__));
                    }
                }
                size_t rem_j_1_max__ = nage;
                for (size_t j_1__ = 0; j_1__ < rem_j_1_max__; ++j_1__) {
                    vars__.push_back(rem(j_1__));
                }
                size_t rem_prob_j_1_max__ = (nage * remission);
                for (size_t j_1__ = 0; j_1__ < rem_prob_j_1_max__; ++j_1__) {
                    vars__.push_back(rem_prob(j_1__));
                }
                size_t cf_prob_j_1_max__ = nage;
                for (size_t j_1__ = 0; j_1__ < cf_prob_j_1_max__; ++j_1__) {
                    vars__.push_back(cf_prob(j_1__));
                }
                size_t state_probs_j_1_max__ = 3;
                size_t state_probs_k_0_max__ = ((nage + 1) * (1 - trend));
                size_t state_probs_k_1_max__ = nbias;
                for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                    for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                            vars__.push_back(state_probs[k_0__][k_1__](j_1__));
                        }
                    }
                }
                size_t tmp_j_1_max__ = 3;
                for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                    vars__.push_back(tmp(j_1__));
                }
                size_t P_j_2_max__ = 3;
                size_t P_j_1_max__ = 3;
                for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                        vars__.push_back(P(j_1__, j_2__));
                    }
                }
                size_t prev_prob_j_2_max__ = nbias;
                size_t prev_prob_j_1_max__ = nage;
                for (size_t j_2__ = 0; j_2__ < prev_prob_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < prev_prob_j_1_max__; ++j_1__) {
                        vars__.push_back(prev_prob(j_1__, j_2__));
                    }
                }
                size_t mort_prob_k_0_max__ = nage;
                for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                    vars__.push_back(mort_prob[k_0__]);
                }
                size_t cf_yr_j_2_max__ = (nyr * trend);
                size_t cf_yr_j_1_max__ = (nage * trend);
                for (size_t j_2__ = 0; j_2__ < cf_yr_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < cf_yr_j_1_max__; ++j_1__) {
                        vars__.push_back(cf_yr(j_1__, j_2__));
                    }
                }
                size_t inc_yr_k_0_max__ = (nage * trend);
                size_t inc_yr_k_1_max__ = (nyr * trend);
                size_t inc_yr_k_2_max__ = nbias;
                for (size_t k_2__ = 0; k_2__ < inc_yr_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < inc_yr_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < inc_yr_k_0_max__; ++k_0__) {
                            vars__.push_back(inc_yr[k_0__][k_1__][k_2__]);
                        }
                    }
                }
                size_t state_probs_yr_j_1_max__ = 3;
                size_t state_probs_yr_k_0_max__ = ((nage + 1) * trend);
                size_t state_probs_yr_k_1_max__ = (nyr * trend);
                size_t state_probs_yr_k_2_max__ = nbias;
                for (size_t j_1__ = 0; j_1__ < state_probs_yr_j_1_max__; ++j_1__) {
                    for (size_t k_2__ = 0; k_2__ < state_probs_yr_k_2_max__; ++k_2__) {
                        for (size_t k_1__ = 0; k_1__ < state_probs_yr_k_1_max__; ++k_1__) {
                            for (size_t k_0__ = 0; k_0__ < state_probs_yr_k_0_max__; ++k_0__) {
                                vars__.push_back(state_probs_yr[k_0__][k_1__][k_2__](j_1__));
                            }
                        }
                    }
                }
                vars__.push_back(lambda_cf_use);
                vars__.push_back(lambda_inc_use);
                vars__.push_back(lambda_rem_use);
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 386;
            validate_non_negative_index("ll_mort", "nage", nage);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_mort(nage);
            stan::math::initialize(ll_mort, DUMMY_VAR__);
            stan::math::fill(ll_mort, DUMMY_VAR__);
            current_statement_begin__ = 387;
            validate_non_negative_index("ll_inc", "(nage * inc_supplied)", (nage * inc_supplied));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_inc((nage * inc_supplied));
            stan::math::initialize(ll_inc, DUMMY_VAR__);
            stan::math::fill(ll_inc, DUMMY_VAR__);
            current_statement_begin__ = 388;
            validate_non_negative_index("ll_prev", "(nage * prev_supplied)", (nage * prev_supplied));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_prev((nage * prev_supplied));
            stan::math::initialize(ll_prev, DUMMY_VAR__);
            stan::math::fill(ll_prev, DUMMY_VAR__);
            current_statement_begin__ = 389;
            validate_non_negative_index("ll_rem", "(nage * remission)", (nage * remission));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_rem((nage * remission));
            stan::math::initialize(ll_rem, DUMMY_VAR__);
            stan::math::fill(ll_rem, DUMMY_VAR__);
            current_statement_begin__ = 390;
            validate_non_negative_index("ll_overall", "(nage * (((1 + inc_supplied) + prev_supplied) + remission))", (nage * (((1 + inc_supplied) + prev_supplied) + remission)));
            Eigen::Matrix<double, Eigen::Dynamic, 1> ll_overall((nage * (((1 + inc_supplied) + prev_supplied) + remission)));
            stan::math::initialize(ll_overall, DUMMY_VAR__);
            stan::math::fill(ll_overall, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 391;
            for (int a = 1; a <= nage; ++a) {
                current_statement_begin__ = 392;
                stan::model::assign(ll_mort, 
                            stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                            binomial_log(get_base1(mort_num, a, "mort_num", 1), get_base1(mort_denom, a, "mort_denom", 1), get_base1(mort_prob, a, "mort_prob", 1)), 
                            "assigning variable ll_mort");
                current_statement_begin__ = 393;
                if (as_bool(inc_supplied)) {
                    current_statement_begin__ = 394;
                    stan::model::assign(ll_inc, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                binomial_log(get_base1(inc_num, a, "inc_num", 1), get_base1(inc_denom, a, "inc_denom", 1), get_base1(inc_prob, a, "inc_prob", 1)), 
                                "assigning variable ll_inc");
                }
                current_statement_begin__ = 395;
                if (as_bool(prev_supplied)) {
                    current_statement_begin__ = 396;
                    stan::model::assign(ll_prev, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                binomial_log(get_base1(prev_num, a, "prev_num", 1), get_base1(prev_denom, a, "prev_denom", 1), get_base1(prev_prob, a, "prev_prob", 1)), 
                                "assigning variable ll_prev");
                }
                current_statement_begin__ = 397;
                if (as_bool(remission)) {
                    current_statement_begin__ = 398;
                    stan::model::assign(ll_rem, 
                                stan::model::cons_list(stan::model::index_uni(a), stan::model::nil_index_list()), 
                                binomial_log(get_base1(rem_num, a, "rem_num", 1), get_base1(rem_denom, a, "rem_denom", 1), get_base1(rem_prob, a, "rem_prob", 1)), 
                                "assigning variable ll_rem");
                }
            }
            current_statement_begin__ = 400;
            stan::math::assign(ll_overall, append_row(ll_mort, append_row(ll_inc, append_row(ll_prev, ll_rem))));
            // validate, write generated quantities
            current_statement_begin__ = 386;
            size_t ll_mort_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
                vars__.push_back(ll_mort(j_1__));
            }
            current_statement_begin__ = 387;
            size_t ll_inc_j_1_max__ = (nage * inc_supplied);
            for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
                vars__.push_back(ll_inc(j_1__));
            }
            current_statement_begin__ = 388;
            size_t ll_prev_j_1_max__ = (nage * prev_supplied);
            for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
                vars__.push_back(ll_prev(j_1__));
            }
            current_statement_begin__ = 389;
            size_t ll_rem_j_1_max__ = (nage * remission);
            for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
                vars__.push_back(ll_rem(j_1__));
            }
            current_statement_begin__ = 390;
            size_t ll_overall_j_1_max__ = (nage * (((1 + inc_supplied) + prev_supplied) + remission));
            for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
                vars__.push_back(ll_overall(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_disbayes";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t inc_par_j_1_max__ = (nage * (1 - smooth_inc));
        for (size_t j_1__ = 0; j_1__ < inc_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inc_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cf_par_j_1_max__ = (nage * (1 - smooth_cf));
        for (size_t j_1__ = 0; j_1__ < cf_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cf_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rem_par_j_1_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        for (size_t j_1__ = 0; j_1__ < rem_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rem_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = ((K * smooth_cf) * (1 - const_cf));
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_j_1_max__ = (smooth_cf * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_inc_j_1_max__ = (K * smooth_inc);
        for (size_t j_1__ = 0; j_1__ < beta_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_rem_j_1_max__ = (smooth_rem * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_rem_j_1_max__ = (K * smooth_rem);
        for (size_t j_1__ = 0; j_1__ < beta_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t prevzero_j_1_max__ = prev_zero;
        for (size_t j_1__ = 0; j_1__ < prevzero_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prevzero" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t bias_loghr_j_1_max__ = logical_eq(nbias, 2);
        for (size_t j_1__ = 0; j_1__ < bias_loghr_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bias_loghr" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cfbase_j_1_max__ = (1 * increasing_cf);
        for (size_t j_1__ = 0; j_1__ < cfbase_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cfbase" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t cf_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t dcf_j_1_max__ = (nage * increasing_cf);
            for (size_t j_1__ = 0; j_1__ < dcf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dcf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t inc_j_2_max__ = nbias;
            size_t inc_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < inc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < inc_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t inc_prob_j_2_max__ = nbias;
            size_t inc_prob_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < inc_prob_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < inc_prob_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc_prob" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rem_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < rem_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rem_prob_j_1_max__ = (nage * remission);
            for (size_t j_1__ = 0; j_1__ < rem_prob_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem_prob" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cf_prob_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_prob_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf_prob" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t state_probs_j_1_max__ = 3;
            size_t state_probs_k_0_max__ = ((nage + 1) * (1 - trend));
            size_t state_probs_k_1_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "state_probs" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P_j_2_max__ = 3;
            size_t P_j_1_max__ = 3;
            for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "P" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t prev_prob_j_2_max__ = nbias;
            size_t prev_prob_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < prev_prob_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prev_prob_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "prev_prob" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mort_prob_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mort_prob" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cf_yr_j_2_max__ = (nyr * trend);
            size_t cf_yr_j_1_max__ = (nage * trend);
            for (size_t j_2__ = 0; j_2__ < cf_yr_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < cf_yr_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "cf_yr" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t inc_yr_k_0_max__ = (nage * trend);
            size_t inc_yr_k_1_max__ = (nyr * trend);
            size_t inc_yr_k_2_max__ = nbias;
            for (size_t k_2__ = 0; k_2__ < inc_yr_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_yr_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_yr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc_yr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t state_probs_yr_j_1_max__ = 3;
            size_t state_probs_yr_k_0_max__ = ((nage + 1) * trend);
            size_t state_probs_yr_k_1_max__ = (nyr * trend);
            size_t state_probs_yr_k_2_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < state_probs_yr_j_1_max__; ++j_1__) {
                for (size_t k_2__ = 0; k_2__ < state_probs_yr_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < state_probs_yr_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < state_probs_yr_k_0_max__; ++k_0__) {
                            param_name_stream__.str(std::string());
                            param_name_stream__ << "state_probs_yr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1 << '.' << j_1__ + 1;
                            param_names__.push_back(param_name_stream__.str());
                        }
                    }
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem_use";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t ll_mort_j_1_max__ = nage;
        for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_mort" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_inc_j_1_max__ = (nage * inc_supplied);
        for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_prev_j_1_max__ = (nage * prev_supplied);
        for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_prev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_rem_j_1_max__ = (nage * remission);
        for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_overall_j_1_max__ = (nage * (((1 + inc_supplied) + prev_supplied) + remission));
        for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_overall" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t inc_par_j_1_max__ = (nage * (1 - smooth_inc));
        for (size_t j_1__ = 0; j_1__ < inc_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "inc_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cf_par_j_1_max__ = (nage * (1 - smooth_cf));
        for (size_t j_1__ = 0; j_1__ < cf_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cf_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t rem_par_j_1_max__ = ((remission * (1 - smooth_rem)) * ((nage * (1 - const_rem)) + (1 * const_rem)));
        for (size_t j_1__ = 0; j_1__ < rem_par_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rem_par" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_j_1_max__ = ((K * smooth_cf) * (1 - const_cf));
        for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_cf_j_1_max__ = (smooth_cf * (1 - scf_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_cf_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_inc_j_1_max__ = (smooth_inc * (1 - sinc_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_inc_j_1_max__ = (K * smooth_inc);
        for (size_t j_1__ = 0; j_1__ < beta_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t lambda_rem_j_1_max__ = (smooth_rem * (1 - srem_isfixed));
        for (size_t j_1__ = 0; j_1__ < lambda_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta_rem_j_1_max__ = (K * smooth_rem);
        for (size_t j_1__ = 0; j_1__ < beta_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t prevzero_j_1_max__ = prev_zero;
        for (size_t j_1__ = 0; j_1__ < prevzero_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prevzero" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t bias_loghr_j_1_max__ = logical_eq(nbias, 2);
        for (size_t j_1__ = 0; j_1__ < bias_loghr_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "bias_loghr" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t cfbase_j_1_max__ = (1 * increasing_cf);
        for (size_t j_1__ = 0; j_1__ < cfbase_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "cfbase" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t cf_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t dcf_j_1_max__ = (nage * increasing_cf);
            for (size_t j_1__ = 0; j_1__ < dcf_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "dcf" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t inc_j_2_max__ = nbias;
            size_t inc_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < inc_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < inc_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t inc_prob_j_2_max__ = nbias;
            size_t inc_prob_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < inc_prob_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < inc_prob_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "inc_prob" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rem_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < rem_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t rem_prob_j_1_max__ = (nage * remission);
            for (size_t j_1__ = 0; j_1__ < rem_prob_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rem_prob" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cf_prob_j_1_max__ = nage;
            for (size_t j_1__ = 0; j_1__ < cf_prob_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "cf_prob" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t state_probs_j_1_max__ = 3;
            size_t state_probs_k_0_max__ = ((nage + 1) * (1 - trend));
            size_t state_probs_k_1_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < state_probs_j_1_max__; ++j_1__) {
                for (size_t k_1__ = 0; k_1__ < state_probs_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < state_probs_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "state_probs" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << j_1__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t tmp_j_1_max__ = 3;
            for (size_t j_1__ = 0; j_1__ < tmp_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tmp" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t P_j_2_max__ = 3;
            size_t P_j_1_max__ = 3;
            for (size_t j_2__ = 0; j_2__ < P_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < P_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "P" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t prev_prob_j_2_max__ = nbias;
            size_t prev_prob_j_1_max__ = nage;
            for (size_t j_2__ = 0; j_2__ < prev_prob_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < prev_prob_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "prev_prob" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t mort_prob_k_0_max__ = nage;
            for (size_t k_0__ = 0; k_0__ < mort_prob_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "mort_prob" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t cf_yr_j_2_max__ = (nyr * trend);
            size_t cf_yr_j_1_max__ = (nage * trend);
            for (size_t j_2__ = 0; j_2__ < cf_yr_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < cf_yr_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "cf_yr" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t inc_yr_k_0_max__ = (nage * trend);
            size_t inc_yr_k_1_max__ = (nyr * trend);
            size_t inc_yr_k_2_max__ = nbias;
            for (size_t k_2__ = 0; k_2__ < inc_yr_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < inc_yr_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < inc_yr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "inc_yr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t state_probs_yr_j_1_max__ = 3;
            size_t state_probs_yr_k_0_max__ = ((nage + 1) * trend);
            size_t state_probs_yr_k_1_max__ = (nyr * trend);
            size_t state_probs_yr_k_2_max__ = nbias;
            for (size_t j_1__ = 0; j_1__ < state_probs_yr_j_1_max__; ++j_1__) {
                for (size_t k_2__ = 0; k_2__ < state_probs_yr_k_2_max__; ++k_2__) {
                    for (size_t k_1__ = 0; k_1__ < state_probs_yr_k_1_max__; ++k_1__) {
                        for (size_t k_0__ = 0; k_0__ < state_probs_yr_k_0_max__; ++k_0__) {
                            param_name_stream__.str(std::string());
                            param_name_stream__ << "state_probs_yr" << '.' << k_0__ + 1 << '.' << k_1__ + 1 << '.' << k_2__ + 1 << '.' << j_1__ + 1;
                            param_names__.push_back(param_name_stream__.str());
                        }
                    }
                }
            }
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_cf_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_inc_use";
            param_names__.push_back(param_name_stream__.str());
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rem_use";
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__) return;
        size_t ll_mort_j_1_max__ = nage;
        for (size_t j_1__ = 0; j_1__ < ll_mort_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_mort" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_inc_j_1_max__ = (nage * inc_supplied);
        for (size_t j_1__ = 0; j_1__ < ll_inc_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_inc" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_prev_j_1_max__ = (nage * prev_supplied);
        for (size_t j_1__ = 0; j_1__ < ll_prev_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_prev" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_rem_j_1_max__ = (nage * remission);
        for (size_t j_1__ = 0; j_1__ < ll_rem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_rem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ll_overall_j_1_max__ = (nage * (((1 + inc_supplied) + prev_supplied) + remission));
        for (size_t j_1__ = 0; j_1__ < ll_overall_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ll_overall" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_disbayes_namespace::model_disbayes stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
