% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discord_data.R
\name{discord_data}
\alias{discord_data}
\title{Restructure Data}
\usage{
discord_data(doubleentered = F, outcome = NULL, predictors = NULL,
  sep = "", scale = T, df = NULL, id = NULL, full = T)
}
\arguments{
\item{doubleentered}{Describes whether data are double entered. Default is FALSE.}

\item{outcome}{Name of outcome variable}

\item{predictors}{Names of predictors. Default is to use all variables in \code{df} that are not the outcome.}

\item{sep}{The character in \code{df} that separates root outcome and predictors from mean and diff labelscharacter string to separate the names of the \code{predictors} and \code{outcome}s from kin identifier (1 or 2). Not \code{NA_character_}.}

\item{scale}{If TRUE, rescale all variables at the individual level to have a mean of 0 and a SD of 1.}

\item{df}{Dataframe with all variables in it.}

\item{id}{id variable (optional).}

\item{full}{If TRUE, returns kin1 and kin2 scores in addition to diff and mean scores. If FALSE, only returns diff and mean scores.}
}
\value{
Returns \code{data.frame} with the following variables:
\item{id}{id}
\item{outcome_1}{outcome for kin1; kin1 is always greater than kin2, except when tied. Then kin1 is randomly selected from the pair}
\item{outcome_2}{outcome for kin2}
\item{outcome_diff}{difference between outcome of kin1 and kin2}
\item{outcome_mean}{mean outcome for kin1 and kin2}
\item{predictor_i_1}{predictor variable i for kin1}
\item{predictor_i_2}{predictor variable i for kin2}
\item{predictor_i_diff}{difference between predictor i of kin1 and kin2}
\item{predictor_i_mean}{mean predictor i for kin1 and kin2}
}
\description{
Restructure wide form data into analyzable data, sorted by outcome.
}
