% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate_edges.R
\name{tabulate_edges}
\alias{tabulate_edges}
\title{Process raw order lists from two column format to edge and weight lists}
\usage{
tabulate_edges(input, iscsvfile = TRUE, silentNodes = 0)
}
\arguments{
\item{input}{Input in question-and-response format. Must be a data.frame or file name of a .csv}

\item{iscsvfile}{Sets if the input is a csv file or a R data frame object}

\item{silentNodes}{The number of nodes that do not interact with other nodes but are in the group}
}
\value{
Saves the weight and edge lists as a data.frame object or a .csv file to disk.
}
\description{
Takes raw input that is in a 2 column format/question-and-response format and generates an appropriate edge and weight lists in a combined .csv file. The weights in this function are determined by the number of occurrences a specific edge has occurred in the graph
}
\examples{
df <- sampleData1
tabData <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)

}
