% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2Att.R
\name{plot2Att}
\alias{plot2Att}
\title{Plots Graphs using ggplot2 with two attributes}
\usage{
plot2Att(
  data,
  prop = 20,
  graphmode = "fruchtermanreingold",
  attribute1 = NULL,
  attribute2 = NULL,
  attribute1.label = "Attribute 1",
  attribute2.label = "Attribute 2",
  attribute.node.labels = NULL,
  attribute.nodesize = 10
)
}
\arguments{
\item{data}{Data from the prepareGraphs function}

\item{prop}{Rescaling the graph edge sizes for the plot}

\item{graphmode}{Type of graphical projection to use. Default is Fruchterman Reingold. Refer to gplot.layout for the various available options}

\item{attribute1}{Mapping to the attribute 1 information, can be list or column in data frame (Required)}

\item{attribute2}{Mapping to the attribute 2 information, can be list or column in data frame (Required)}

\item{attribute1.label}{Name of the attribute 1 info (Required)}

\item{attribute2.label}{Name of the attribute 2 info (Required)}

\item{attribute.node.labels}{Mapping to the node labels, can be list or column in data frame (Required)}

\item{attribute.nodesize}{Size of the nodes. Default will result in size of 10. Can be replaced with custom mapping in list or column in data frame. (Required)}
}
\description{
Plots graph data using the GGally library and ggnet function while incorporating demographic properties. Use this plot function if you have all demographic data available to plot.
}
\examples{
\donttest{
df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1", weightedGraph = TRUE)
attdata <- attributeData
plot2Att(baseNet, prop = 20, graphmode = "fruchtermanreingold",
attribute1 = attdata$gender, attribute2 = attdata$ethnicity,
attribute1.label = "Gender", attribute2.label = "Ethnicity",
attribute.node.labels = attdata$node, attribute.nodesize = 12)
}
}
