% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrim_flexible.R
\name{discrim_flexible}
\alias{discrim_flexible}
\title{Flexible discriminant analysis}
\usage{
discrim_flexible(
  mode = "classification",
  engine = "earth",
  num_terms = NULL,
  prod_degree = NULL,
  prune_method = NULL
)
}
\arguments{
\item{mode}{A single character string for the type of model. The only
possible value for this model is "classification".}

\item{engine}{A single character string specifying what computational engine to use
for fitting.}

\item{num_terms}{The number of features that will be retained in the
final model, including the intercept.}

\item{prod_degree}{The highest possible interaction degree.}

\item{prune_method}{The pruning method.}
}
\description{
\code{discrim_flexible()} defines a model that fits a discriminant analysis model
that can use nonlinear features created using multivariate adaptive
regression splines (MARS).

There are different ways to fit this model. See the engine-specific pages
for more details:

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("discrim_flexible", "discrim")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit.model_spec()}} function is used
with the data.
}
\examples{
parabolic_grid <-
  expand.grid(X1 = seq(-5, 5, length = 100),
              X2 = seq(-5, 5, length = 100))

fda_mod <-
  discrim_flexible(num_terms = 3) \%>\%
  # increase `num_terms` to find smoother boundaries
  set_engine("earth") \%>\%
  fit(class ~ ., data = parabolic)

parabolic_grid$fda <-
  predict(fda_mod, parabolic_grid, type = "prob")$.pred_Class1

library(ggplot2)
ggplot(parabolic, aes(x = X1, y = X2)) +
  geom_point(aes(col = class), alpha = .5) +
  geom_contour(data = parabolic_grid, aes(z = fda), col = "black", breaks = .5) +
  theme_bw() +
  theme(legend.position = "top") +
  coord_equal()
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org}{\emph{Tidy Models with R}}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("discrim_flexible", "discrim")}
}
