% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_R6_utils.R
\name{\%.\%}
\alias{\%.\%}
\title{Existence aware pick operator}
\usage{
env \%.\% field
}
\arguments{
\item{env}{(\code{object})\cr
The object or environment to attempt to pick from}

\item{field}{(\code{character})\cr
The name of the field to pick from \code{env}}
}
\value{
Error if the \code{field} does not exist in \code{env}, otherwise it returns \code{field}
}
\description{
Existence aware pick operator
}
\examples{
 t <- list(a = 1, b = 2)

 t$a       # 1
 t \%.\% a   # 1

 t$c # NULL
 try(t \%.\% c) # Gives error since "c" does not exist in "t"
}
