% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{market_aggregation}
\alias{market_aggregation}
\alias{aggregate_demand}
\alias{aggregate_demand,market_model-method}
\alias{aggregate_supply}
\alias{aggregate_supply,market_model-method}
\title{Market side aggregation.}
\usage{
aggregate_demand(object, parameters)

\S4method{aggregate_demand}{market_model}(object, parameters)

aggregate_supply(object, parameters)

\S4method{aggregate_supply}{market_model}(object, parameters)
}
\arguments{
\item{object}{A model object.}

\item{parameters}{A vector of model's parameters.}
}
\value{
The sum of the estimated demanded or supplied quantities evaluated at the
given parameters.
}
\description{
Market side aggregation.
}
\details{
Calculates the sample's aggregate demand or supply at the passed set of
parameters. If the model is static, as is for example the case of
\code{\linkS4class{equilibrium_model}}, then all observations are aggregated. If the
used data have a time dimension and aggregation per date is required, it can be
manually performed using the \code{\link{demanded_quantities}} and
\code{\link{supplied_quantities}} functions. If the model has a dynamic component,
such as the \code{\linkS4class{diseq_deterministic_adjustment}}, then demanded
and supplied quantities are automatically aggregated for each time point.
}
\section{Functions}{
\itemize{
\item \code{aggregate_demand}: Demand aggregation.

\item \code{aggregate_supply}: Supply aggregation.
}}

\examples{
\donttest{
# initialize the basic model using the houses dataset
model <- new(
  "diseq_basic", # model type
  c("ID", "TREND"), "HS", "RM", # keys, quantity, and price variables
  "RM + TREND + W + CSHS + L1RM + L2RM + MONTH", # demand specification
  "RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH", # supply specification
  fair_houses(), # data
  correlated_shocks = FALSE # allow shocks to be correlated
)

# estimate the model object (BFGS is used by default)
est <- estimate(model)

# get estimated aggregate demand
aggregate_demand(model, est@coef)

# simulate the deterministic adjustment model
model <- simulate_model(
  "diseq_deterministic_adjustment", list(
    # observed entities, observed time points
    nobs = 500, tobs = 3,
    # demand coefficients
    alpha_d = -0.6, beta_d0 = 9.8, beta_d = c(0.3, -0.2), eta_d = c(0.6, -0.1),
    # supply coefficients
    alpha_s = 0.2, beta_s0 = 4.1, beta_s = c(0.9), eta_s = c(-0.5, 0.2),
    # price equation coefficients
    gamma = 0.9
  ), seed = 1356
)

# estimate the model object
est <- estimate(model)

# get estimated aggregate demand
aggregate_demand(model, est@coef)

# get estimated aggregate demand
aggregate_supply(model, est@coef)
}
}
\seealso{
demanded_quantities, supplied_quantities
}
