% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_frac.R
\name{sample_frac.disk.frame}
\alias{sample_frac.disk.frame}
\title{Sample n rows from a disk.frame}
\usage{
\method{sample_frac}{disk.frame}(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...)
}
\arguments{
\item{tbl}{A data.frame.}

\item{size}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>
For \code{sample_n()}, the number of rows to select.
For \code{sample_frac()}, the fraction of rows to select.
If \code{tbl} is grouped, \code{size} applies to each group.}

\item{replace}{Sample with or without replacement?}

\item{weight}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Sampling weights.
This must evaluate to a vector of non-negative numbers the same length as
the input. Weights are automatically standardised to sum to 1.}

\item{.env}{DEPRECATED.}

\item{...}{ignored}
}
\description{
Sample n rows from a disk.frame
}
\examples{
cars.df = as.disk.frame(cars)

collect(sample_frac(cars.df, 0.5))

# clean up cars.df
delete(cars.df)
}
