## Converting a list of characters (ape format) into the Claddis format
convert.to.Claddis <- function(data) {
    output <- list()
    
    ## Topper
    output$topper$head <- "List generated by dispRity::Claddis.ordination"

    ## Matrix_1
    output$matrix_1$block_name <- NA
    output$matrix_1$datatype <- "STANDARD"
    output$matrix_1$matrix <- do.call(rbind, data)
    output$matrix_1$ordering <- rep("unord", length(data[[1]]))
    output$matrix_1$character_weights <- rep(1, length(data[[1]]))
    op <- options(warn = -1)
    output$matrix_1$minimum_values <- unlist(apply(output$matrix_1$matrix, 2, function(x) min(as.numeric(x), na.rm = TRUE)))
    is_nas <- is.na(output$matrix_1$minimum_values)
    output$matrix_1$maximum_values <- unlist(apply(output$matrix_1$matrix, 2, function(x) max(as.numeric(x), na.rm = TRUE)))
    output$matrix_1$characters$symbols <- unique(as.numeric(unlist(data)[-which(is.na(unlist(data)))]))
    op <- options(warn = 0)
    output$matrix_1$characters$missing <- "?"
    output$matrix_1$characters$gap <- "-"

    ## Transform the missing data into "?"
    output$matrix_1$matrix <- ifelse(output$matrix_1$matrix == "?", NA, output$matrix_1$matrix)
    ## Transform the inapplicables in ""
    output$matrix_1$matrix <- ifelse(output$matrix_1$matrix == "-", "", output$matrix_1$matrix)

    class(output) <- "cladisticMatrix"

    return(output)
}
