% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difftime.R
\name{difference_in_time}
\alias{difference_in_time}
\alias{difftime_financial}
\alias{difftime_compare}
\title{Difference in time}
\usage{
difftime_financial(
  from,
  to,
  pre_market = 8,
  after_market = 22,
  units = "hours"
)

difftime_compare(from, to, time_threshold = "0 mins")
}
\arguments{
\item{from}{POSIXct for the initial date.}

\item{to}{POSIXct for the final date.}

\item{pre_market}{numeric or character representing the hour of the day at
which the pre-market begins.}

\item{after_market}{numeric or character representing the hour of the day at
which the after-market ends.}

\item{units}{Character string specifying a time unit.
(See \code{base::\link[base:difftime]{difftime}}).}

\item{time_threshold}{Character in the format "value units" indicating the
time threshold at which the computed financial difftime has to be evaluated
(for instance "05 mins" or "20 hours").
The allowed units are "secs", "mins", "hours", "days" and "weeks"
(See \code{base::\link[base:difftime]{difftime}}).}
}
\value{
\describe{
\item{\code{difftime_financial}}{returns a numeric value in hours.
To convert in a different time unit use
\code{base::\link[base:as.numeric]{as.numeric}} and specify the
\code{units} argument (units = c("secs", "mins", "hours", "days",
"weeks")).}
\item{\code{difftime_compare}}{returns a character string whose possible
values are "greater" or "smaller", indicating whether the
\code{difftime_financial} evaluated between the two dates is greater or
smaller than the chosen threshold.}
}
}
\description{
Financial implementation of
\code{base::\link[base:difftime]{difftime}}, that takes into account
trading day horizons (including pre and after market hours.)
}
\section{Functions}{
\itemize{
\item \code{difftime_financial}: Extension of the
\code{base::\link[base:difftime]{difftime}} function to calculate the
actual financial difftime taking into account pre and after market
moments and financial markets closing days.

\item \code{difftime_compare}: Comparison of the \code{difftime_financial}
with respect to a given time threshold.
}}

\seealso{
\code{base::\link[base:difftime]{difftime}}
}
\keyword{internal}
