% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{read_and_unite_files}
\alias{read_and_unite_files}
\title{Read and unite files}
\usage{
read_and_unite_files(
  path,
  pattern,
  sep = ";",
  header = TRUE,
  add.file.id = FALSE,
  file.id = NULL,
  unique = FALSE
)
}
\arguments{
\item{path}{character; directory path}

\item{pattern}{character; file names pattern}

\item{sep}{character; the field separator character}

\item{header}{logical; files contain the names of the variables as its first line}

\item{add.file.id}{logical; add file identification columns}

\item{file.id}{data frame with file identification values}

\item{unique}{logical; delete repeated rows}
}
\value{
data frame with united files' content.
}
\description{
Read a bunch of table files and unite them in one data frame
}
\details{
All files must be tables of same type. All files must be in one directory.

File identification columns might be added. There might be any number of such columns.
They are added at the beginning of result data frame.
File identification values are set as \code{file.id} data frame,
where each column contains possible identification values and column names are names of identificator.
If no \code{file.id} provided file names are set by default.
}
\examples{
path <- tempdir()
dir.create(path)
t1<-paste0(path, "/table1")
t2<-paste0(path, "/table2")
table1 <- data.frame (Num = 1:10, Letter = rep("A", 10))
write.table (table1, t1, sep = ";")
table2 <- data.frame (Num = 1:10, Letter = rep("B", 10))
write.table (table2, t2, sep = ";")
read_and_unite_files (path = path, pattern = "table", header = TRUE, sep = ";",
                      add.file.id = TRUE)
read_and_unite_files (path = path, pattern = "table", header = TRUE, sep = ";",
                      add.file.id = TRUE,
                      file.id = data.frame (id1 = c(1,2), id2 = c("one", "two")))
file.remove (t1); file.remove (t2)

}
\author{
Elena N. Filatova
}
