% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowPsiHP.R
\name{workflowPsiHP}
\alias{workflowPsiHP}
\title{A refactored version of \code{\link{workflowPsi}} with a higher performance (hence the suffix HP).}
\usage{
workflowPsiHP(
  sequences = NULL,
  grouping.column = NULL,
  time.column = NULL,
  exclude.columns = NULL,
  parallel.execution = TRUE
  )
}
\arguments{
\item{sequences}{dataframe with multiple sequences identified by a grouping column generated by \code{\link{prepareSequences}}.}

\item{grouping.column}{character string, name of the column in \code{sequences} to be used to identify separates sequences within the file.}

\item{time.column}{character string, name of the column with time/depth/rank data.}

\item{exclude.columns}{character string or character vector with column names in \code{sequences} to be excluded from the analysis.}

\item{parallel.execution}{boolean, if \code{TRUE} (default), execution is parallelized, and serialized if \code{FALSE}.}
}
\value{
A dataframe with sequence names and psi values.
}
\description{
Ideal for large analyses with hundreds to thousands of sequences. Several options available in \code{\link{workflowPsi}} have been removed from this function in order to simplify the code as much as possible. Psi is computed with the options \code{diagonal = TRUE}, \code{ignore.blocks = TRUE}, and \code{method = "euclidean"}.
}
\details{
Due to limitations of the function \code{\link[arrangements]{permutations}}, the maximum number of groups (according to \code{grouping.column}) is around 30000. Besides, a combinations table of this size takes, roughlyl, 7GB of memory.
}
\examples{

\donttest{
data("sequencesMIS")
#prepare sequences
MIS.sequences <- prepareSequences(
  sequences = sequencesMIS[sequencesMIS$MIS \%in\% c("MIS-1", "MIS-2"), ],
  grouping.column = "MIS",
  if.empty.cases = "zero",
  transformation = "hellinger"
  )

#execute workflow to compute psi
MIS.psi <- workflowPsiHP(
 sequences = MIS.sequences,
 grouping.column = "MIS",
 parallel.execution = FALSE
 )

MIS.psi

}

}
\author{
Blas Benito <blasbenito@gmail.com>
}
