% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_smooth_exponential.R
\name{zoo_smooth_exponential}
\alias{zoo_smooth_exponential}
\title{Exponential Smoothing of Zoo Time Series}
\usage{
zoo_smooth_exponential(x = NULL, alpha = 0.2)
}
\arguments{
\item{x}{(required, zoo object) time series to smooth Default: NULL}

\item{alpha}{(required, numeric) Smoothing factor in the range (0, 1]. Determines the weight of the current value relative to past values. A higher value gives more weight to recent observations, while a lower value gives more weight to past observations. Default: 0.2}
}
\value{
zoo object
}
\description{
Applies exponential smoothing to a zoo time series object, where each value is a weighted average of the current value and past smoothed values. This method is useful for reducing noise in time series data while preserving the general trend.
}
\examples{
x <- zoo_simulate()

x_smooth <- zoo_smooth_exponential(
  x = x,
  alpha = 0.2
)

if(interactive()){
  zoo_plot(x)
  zoo_plot(x_smooth)
}
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_to_tsl}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
