% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrogate.R
\name{Surrogate}
\alias{Surrogate}
\title{Surrogate class description}
\description{
The class for distilled surrogate models.
}
\note{
Do not initalize this class on its own. It is automatically created
      by the distill function for the interpreter class.
}
\examples{
\donttest{
library(distillML)
library(Rforestry)
set.seed(491)
data <- MASS::crabs

levels(data$sex) <- list(Male = "M", Female = "F")
levels(data$sp) <- list(Orange = "O", Blue = "B")
colnames(data) <- c("Species","Sex","Index","Frontal Lobe",
"Rear Width", "Carapace Length","Carapace Width","Body Depth")

test_ind <- sample(1:nrow(data), 180)
train_reg <- data[-test_ind,]
test_reg <- data[test_ind,]


forest <- forestry(x=train_reg[,-which(names(train_reg)=="Carapace Width")],
y=train_reg[,which(names(train_reg)=="Carapace Width")])

forest_predictor <- Predictor$new(model = forest, data=train_reg,
y="Carapace Width", task = "regression")

forest_interpret <- Interpreter$new(predictor = forest_predictor)

# Both initializations of a surrogate class result in the same surrogate model
surrogate.model <- distill(forest_interpret)
surrogate.model <- distill(forest_interpret,
                           center.mean = TRUE,
                           features = 1:length(forest_interpret$features),
                           cv = FALSE,
                           snap.grid = TRUE,
                           snap.train = TRUE)

}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{interpreter}}{The interpreter object to use as a standardized wrapper for the model}

\item{\code{features}}{The indices of the features in the data used in the surrogate model}

\item{\code{weights}}{The weights used to recombine the PDPs into a surrogate for the original model}

\item{\code{intercept}}{The intercept term we use for our predictions}

\item{\code{feature.centers}}{The center value for the features determined in the model}

\item{\code{center.mean}}{Boolean value that determines whether we use the mean-centered
data for our predictions}

\item{\code{grid}}{A list of PDPS that determine our prediction.}

\item{\code{snap.grid}}{Boolean that determines whether we use grid.points}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Surrogate$new()}}
\item \href{#method-clone}{\code{Surrogate$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Surrogate$new(
  interpreter,
  features,
  weights,
  intercept,
  feature.centers,
  center.mean,
  grid,
  snap.grid
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{interpreter}}{The interpreter object we want to build a surrogate model for.}

\item{\code{features}}{The indices of features in the training data used for the surrogate model}

\item{\code{weights}}{The weights for each given feature after the surrogate model is fit.}

\item{\code{intercept}}{The baseline value. If uncentered, this is 0, and if centered,
this will be the mean of the predictions of the original model
on the training data.}

\item{\code{feature.centers}}{The baseline value for the effect of each feature. If uncentered, this is 0.}

\item{\code{center.mean}}{A boolean value that shows whether this model is a centered or uncentered model}

\item{\code{grid}}{A list of dataframes containing the pre-calculated values used to generate predictions
if snap.grid is TRUE}

\item{\code{snap.grid}}{Boolean that determines if we use previously calculated values
or re-predict using the functions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A surrogate model object that we can use for predictions
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Surrogate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
