% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gumbel.R
\name{dist_gumbel}
\alias{dist_gumbel}
\title{The Gumbel distribution}
\usage{
dist_gumbel(alpha, scale)
}
\arguments{
\item{alpha}{location parameter.}

\item{scale}{parameter. Must be strictly positive.}
}
\description{
\lifecycle{stable}
}
\details{
The Gumbel distribution is a special case of the Generalized Extreme Value
distribution, obtained when the GEV shape parameter \eqn{\xi} is equal to 0.
It may be referred to as a type I extreme value distribution.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a Gumbel random variable with location
parameter  \code{mu} = \eqn{\mu}, scale parameter \code{sigma} = \eqn{\sigma}.

\strong{Support}: \eqn{R}, the set of all real numbers.

\strong{Mean}: \eqn{\mu + \sigma\gamma}, where \eqn{\gamma} is Euler's
constant, approximately equal to 0.57722.

\strong{Median}: \eqn{\mu - \sigma\ln(\ln 2)}{\mu - \sigma ln(ln 2)}.

\strong{Variance}: \eqn{\sigma^2 \pi^2 / 6}.

\strong{Probability density function (p.d.f)}:

\deqn{f(x) = \sigma ^ {-1} \exp[-(x - \mu) / \sigma]%
        \exp\{-\exp[-(x - \mu) / \sigma] \}}{%
       f(x) = (1 / \sigma) exp[-(x - \mu) / \sigma]%
        exp{-exp[-(x - \mu) / \sigma]}}
for \eqn{x} in \eqn{R}, the set of all real numbers.

\strong{Cumulative distribution function (c.d.f)}:

In the \eqn{\xi = 0} (Gumbel) special case
\deqn{F(x) = \exp\{-\exp[-(x - \mu) / \sigma] \}}{%
        F(x) = exp{ - exp[-(x - \mu) / \sigma]} }
for \eqn{x} in \eqn{R}, the set of all real numbers.
}
\examples{
dist <- dist_gumbel(alpha = c(0.5, 1, 1.5, 3), scale = c(2, 2, 3, 4))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[actuar:Gumbel]{actuar::Gumbel}
}
