% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{quantile}
\alias{quantile}
\title{Find the quantile of a probability distribution}
\usage{
quantile(d, p, ...)
}
\arguments{
\item{d}{A probability distribution object such as those created by
a call to \code{\link[=Bernoulli]{Bernoulli()}}, \code{\link[=Beta]{Beta()}}, or \code{\link[=Binomial]{Binomial()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
TODO: Note that this current masks the \code{\link[stats:quantile]{stats::quantile()}} generic
to allow for consistent argument names and warnings when arguments
disappear into \code{...}.
}
\examples{

X <- Normal()

cdf(X, c(0.2, 0.4, 0.6, 0.8))
}
