% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Frechet.R
\name{random.Frechet}
\alias{random.Frechet}
\title{Draw a random sample from a Frechet distribution}
\usage{
\method{random}{Frechet}(x, n = 1L, ...)
}
\arguments{
\item{x}{A \code{Frechet} object created by a call to \code{\link[=Frechet]{Frechet()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from a Frechet distribution
}
\examples{

set.seed(27)

X <- Frechet(0, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
