% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LogNormal.R
\name{pdf.LogNormal}
\alias{pdf.LogNormal}
\alias{log_pdf.LogNormal}
\title{Evaluate the probability mass function of a LogNormal distribution}
\usage{
\method{pdf}{LogNormal}(d, x, drop = TRUE, ...)

\method{log_pdf}{LogNormal}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{LogNormal} object created by a call to \code{\link[=LogNormal]{LogNormal()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{dlnorm}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Please see the documentation of \code{\link[=LogNormal]{LogNormal()}} for some properties
of the LogNormal distribution, as well as extensive examples
showing to how calculate p-values and confidence intervals.
}
\examples{

set.seed(27)

X <- LogNormal(0.3, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other LogNormal distribution: 
\code{\link{cdf.LogNormal}()},
\code{\link{fit_mle.LogNormal}()},
\code{\link{quantile.LogNormal}()},
\code{\link{random.LogNormal}()}
}
\concept{LogNormal distribution}
