% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singletons.R
\name{singletons}
\alias{singletons}
\title{List of singleton taxa}
\usage{
singletons(
  dat,
  tax = "clgen",
  var = NULL,
  bin = NULL,
  bybin = FALSE,
  na.rm = TRUE
)
}
\arguments{
\item{dat}{(\code{data.frame}): Occurrence dataset, with \code{bin}, \code{tax} and \code{coll} as column names.}

\item{tax}{(\code{character}): The name of the taxon variable.}

\item{var}{(\code{character}): The variable that is used to define singletons. Use the reference variable for single-reference taxa, and the collection variable for single-collection taxa, the bin identifier for single-interval taxa and so forth. If you set this to the default \code{NULL}, the function will return single-occurrence taxa.}

\item{bin}{(\code{character}): Lists of taxa can be tabulated in every bin. Rows with \code{NA} entries in this column will be omitted.}

\item{bybin}{(\code{logical}): The type of the filtering process. Was it supposed to be applied to bin-specific subsets (\code{TRUE}), or the whole data (\code{FALSE})? Setting this argument to \code{TRUE} will return a \code{list} class object, where every element of the list is a bin-specific \code{character} vector. This settig also removes all \code{NA} entries form \code{bin} variable.}

\item{na.rm}{(\code{logical}): If \code{var} is not \code{NULL}, setting this argument to \code{TRUE} removes all rows where var is \code{NA}. Otherwise these will be returned as singletons.}
}
\value{
A vector of character entries in \code{tax}.
}
\description{
The function returns lists of taxa that occurr with only one particular entry in a given variable.
}
\details{
Singletons are defined in number of ways in the literature. True singletons are species that are represented by only one specimen, but one can talk about
single-occurrence, single-interval, single-reference or single collection taxa as well. These can be returned with this function. 

As the time bin has particular importance, it is possible to filter singleton taxa in the context of a single bin. These can be returned with the \code{bybin} argument, that constrains and iterates the filtering to every bin.
If this argument is set to \code{TRUE} and the variable in question is a references, than single-reference taxa will be taxa that occurred in only one reference within each bin - it does not necessarily mean that only one reference describes the taxon in the total database!
}
\examples{
# load example dataset
  data(corals)

# Example 1. single-occurrence taxa
  singOcc <- singletons(corals, tax="genus", bin="stg")

# Example 2. output for every bin
  singOccBin <- singletons(corals, tax="genus", bin="stg", bybin=TRUE)

# Example 3. single-interval taxa (all)
  singInt <- singletons(corals, tax="genus", var="stg")

# Example 4. single interval taxa (for every bin)
  singIntBin <- singletons(corals, tax="genus", var="stg", bin="stg", bybin=TRUE)

# Example 5. single reference taxa (total dataset)
  singRef <- singletons(corals, tax="genus", var="reference_no")

#  Example 6. single reference taxa (see description for differences )
  singRefBin <- singletons(corals, tax="genus", var="reference_no", bin="stg", bybin=TRUE)

}
