% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.species_distribution.R
\name{plot.species_distribution}
\alias{plot.species_distribution}
\alias{autoplot.species_distribution}
\title{Plot Profile Objects}
\usage{
\method{plot}{species_distribution}(
  x,
  type = c("RAC", "Metacommunity"),
  ...,
  fit_rac = FALSE,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  ylog = "y",
  main = NULL,
  xlab = "Rank",
  ylab = NULL,
  palette = "Set1"
)

\method{autoplot}{species_distribution}(
  object,
  ...,
  fit_rac = FALSE,
  distribution = c("lnorm", "lseries", "geom", "bstick"),
  ylog = TRUE,
  main = NULL,
  xlab = "Rank",
  ylab = NULL,
  pch = ggplot2::GeomPoint$default_aes$shape,
  cex = ggplot2::GeomPoint$default_aes$size
)
}
\arguments{
\item{x}{An object.}

\item{type}{The type of plot. "RAC" (Rank-abundance curve, or Whittaker plot)
or "Metacommunity" to represent species abundances of each community along
with those of the metacommunity.}

\item{...}{Additional arguments to be passed to \link{plot}. Unused elsewhere.}

\item{fit_rac}{If \code{TRUE}, estimate a theoretical distribution and fit the data with it.
RAC plot only.}

\item{distribution}{The distribution of species abundances.
May be "lnorm" (log-normal), "lseries" (log-series), "geom" (geometric) or
"bstick" (broken stick).
RAC plot only.}

\item{ylog}{If \code{TRUE}, the Y-axis is in log-scale.
RAC plot only.}

\item{main}{The title of the plot.}

\item{xlab}{The label of the X-axis.
RAC plot only.}

\item{ylab}{The  label of the Y-axis.}

\item{palette}{The name of a color palette, recognized by \link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal}.
RAC plot only.}

\item{object}{An object of class \link{species_distribution}.}

\item{pch}{The plotting characters. See \link[graphics:points]{graphics::points}.}

\item{cex}{The character expansion (size) of the points. See \link[graphics:points]{graphics::points}.}
}
\value{
\code{NULL}. Called for side effects.
}
\description{
Plot objects of class "species_distribution" produced by
\link{species_distribution} and similar functions.
}
