% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ent_phylo.R
\name{ent_phylo}
\alias{ent_phylo}
\alias{ent_phylo.numeric}
\alias{ent_phylo.species_distribution}
\title{Phylogenetic Entropy of a Community}
\usage{
ent_phylo(x, tree, q = 1, ...)

\method{ent_phylo}{numeric}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Marcon",
    "UnveilC", "UnveiliC", "ZhangGrabchak", "naive", "Bonachela", "Holste"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)

\method{ent_phylo}{species_distribution}(
  x,
  tree,
  q = 1,
  normalize = TRUE,
  estimator = c("UnveilJ", "ChaoJost", "ChaoShen", "GenCov", "Grassberger", "Marcon",
    "UnveilC", "UnveiliC", "ZhangGrabchak", "naive", "Bonachela", "Holste"),
  level = NULL,
  probability_estimator = c("Chao2015", "Chao2013", "ChaoShen", "naive"),
  unveiling = c("geometric", "uniform", "none"),
  richness_estimator = c("jackknife", "iChao1", "Chao1", "naive"),
  jack_alpha = 0.05,
  jack_max = 10,
  coverage_estimator = c("ZhangHuang", "Chao", "Turing", "Good"),
  gamma = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a named numeric vector (names are species names)
containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{tree}{an ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{q}{a number: the order of diversity.}

\item{...}{Unused.}

\item{normalize}{if \code{TRUE}, phylogenetic is normalized: the height of the tree is set to 1.}

\item{estimator}{An estimator of entropy.}

\item{level}{the level of interpolation or extrapolation.
It may be a sample size (an integer) or a sample coverage
(a number between 0 and 1).
If not \code{NULL}, the asymptotic \code{estimator} is ignored.}

\item{probability_estimator}{a string containing one of the possible estimators
of the probability distribution (see \link{probabilities}).
Used only for extrapolation.}

\item{unveiling}{a string containing one of the possible unveiling methods
to estimate the probabilities of the unobserved species (see \link{probabilities}).
Used only for extrapolation.}

\item{richness_estimator}{an estimator of richness to evaluate the total number of species,
see \link{div_richness}. used for interpolation and extrapolation.}

\item{jack_alpha}{the risk level, 5\% by default, used to optimize the jackknife order.}

\item{jack_max}{the highest jackknife order allowed. Default is 10.}

\item{coverage_estimator}{an estimator of sample coverage used by \link{coverage}.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated
entropy.
}
\description{
Estimate the entropy of species from abundance or probability data
and a phylogenetic tree.
Several estimators are available to deal with incomplete sampling.
}
\details{
Bias correction requires the number of individuals.
See \link{div_hill} for estimators.

Entropy can be estimated at a specified level of interpolation or
extrapolation, either a chosen sample size or sample coverage
\insertCite{Chao2014}{divent}, rather than its asymptotic value.
See \link{accum_tsallis} for details.
}
\examples{
# Entropy of each community
ent_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2)
# Gamma entropy
ent_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2, gamma = TRUE)

# At 80\% coverage
ent_phylo(paracou_6_abd, tree = paracou_6_taxo, q = 2, level = 0.8)


}
\references{
\insertAllCited{}
}
