% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_spatial.R
\name{spat.beta}
\alias{spat.beta}
\title{Spatial beta diversity for raster}
\usage{
spat.beta(
  x,
  tree,
  filename = NULL,
  global = FALSE,
  fm = NULL,
  d = mean(terra::res(terra::rast(x))) * 2,
  type = "circle",
  na.policy = "omit",
  ...
)
}
\arguments{
\item{x}{A SpatRaster with presence-absence data (0 or 1) for a
set of species.}

\item{tree}{A data.frame with species traits or a phylogenetic
tree.}

\item{filename}{Character. Save results if a name is provided.}

\item{global}{Logical. Mean of pairwise comparisons between
focal cell and its neighbors (default) or mean of all pairwise
comparisons.}

\item{fm}{Numeric. Focal matrix ("moving window").}

\item{d}{Window radius to compute beta diversity.}

\item{type}{Character. Window format. Default = "circle".}

\item{na.policy}{Character. Default = "omit".
See ?terra::focal3D for details.}

\item{...}{Additional arguments to be passed passed down from
a calling function.}
}
\value{
A SpatRaster with beta results (total, replacement,
and richness differences).
}
\description{
Spatial beta diversity for raster
}
\examples{
\donttest{
library(terra)
bin1 <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
rownames(traits) <- names(bin1)
tree <- ape::read.tree(system.file("extdata", "tree.tre",
package = "divraster"))
spat.beta(bin1)
spat.beta(bin1, traits)
spat.beta(bin1, tree)
}
}
