% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episode_group.R
\name{windows}
\alias{windows}
\alias{epid_windows}
\alias{epid_lengths}
\alias{index_window}
\title{Window and lengths}
\usage{
epid_windows(date, lengths, episode_unit = "days")

epid_lengths(date, windows, episode_unit = "days")

index_window(date, from_last = F)
}
\arguments{
\item{date}{As used in \bold{\code{\link{episodes}}}.}

\item{lengths}{\code{case_length} or \code{recurrence_length} arguments as used in \bold{\code{\link{episodes}}}.}

\item{episode_unit}{Time unit of \code{lengths}. Options are "seconds", "minutes", "hours", "days", "weeks", "months" or "years". See \code{diyar::episode_unit}.}

\item{windows}{A range or period relative to \code{date} for a given \code{lengths}.}

\item{from_last}{As used in \bold{\code{\link{episodes}}}.}
}
\value{
\code{\link{number_line}}.
}
\description{
Interpret \code{windows}, \code{case_lengths} and \code{recurrence_lengths} as used in \code{\link{episodes}}.
}
\details{
\bold{\code{epid_windows}} - returns the corresponding period for a given a \code{date}, and \code{case_length} or \code{recurrence_length}.
\bold{\code{epid_lengths}} - returns the corresponding \code{case_length} or \code{recurrence_length} for a given \code{date} and period.
}
\examples{

# `epid_windows`
epid_windows(Sys.Date(), 10)
epid_windows(Sys.Date(), number_line(5, 10))
epid_windows(Sys.Date(), number_line(-5, 10))
epid_windows(Sys.Date(), -5)

# `epid_lengths`
epid_lengths(number_line(01, 20), 30)
epid_lengths(number_line(01, 20), number_line(25, 30))
epid_lengths(number_line(01, 20), number_line(-10, 30))
epid_lengths(number_line(01, 20), -10)

index_window(20)
index_window(as.number_line(20))
index_window(number_line(15, 20))

}
