% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{binning_by}
\alias{binning_by}
\title{Optimal Binning for Scoring Modeling}
\usage{
binning_by(df, y, x, p = 0.05, ordered = TRUE, labels = NULL)
}
\arguments{
\item{df}{a data frame.}

\item{y}{character. name of binary response variable(0, 1). 
The variable must contain only the integers 0 and 1 as element. 
However, in the case of factor having two levels, it is performed while type conversion is performed in the calculation process.
It does not support that the variable name is "default" 
and that the dot is included in the variable name.}

\item{x}{character. name of continuous characteristic variable. At least 5 different values.
Inf is not allowed. It does not support that the variable name that the dot is included in the variable name.}

\item{p}{numeric. percentage of records per bin. Default 5\% (0.05).
This parameter only accepts values greater that 0.00 (0\%) and lower than 0.50 (50\%).}

\item{ordered}{logical. whether to build an ordered factor or not.}

\item{labels}{character. the label names to use for each of the bins.}
}
\value{
an object of "optimal_bins" class.
Attributes of "optimal_bins" class is as follows.
\itemize{
\item class : "optimal_bins".
\item type : binning type, "optimal".
\item breaks : numeric. the number of intervals into which x is to be cut.
\item levels : character. levels of binned value.
\item raw : numeric. raw data, x argument value.
\item ivtable : data.frame. information value table
\item iv : numeric. information value
\item target : integer. binary response variable
}
}
\description{
The binning_by() finding intervals for numerical variable
using optical binning. Optimal binning categorizes a numeric characteristic
into bins for ulterior usage in scoring modeling.
}
\details{
This function is useful when used with the mutate/transmute
function of the dplyr package. And this function is implemented using
smbinning() function of smbinning package.
}
\section{attributes of "optimal_bins" class}{

Attributes of the "optimal_bins" class that is as follows.
\itemize{
\item class : "optimal_bins".
\item levels : character. factor or ordered factor levels
\item type : character. binning method
\item breaks : numeric. breaks for binning
\item raw : numeric. before the binned the raw data
\item ivtable : data.frame. information value table
\item iv : numeric. information value
\item target : integer. binary response variable
}

See vignette("transformation") for an introduction to these concepts.
}

\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# optimal binning
bin <- binning_by(carseats, "US", "Advertising")
bin
# summary optimal_bins class
summary(bin)
# visualize optimal_bins class
plot(bin, sub = "bins of Advertising variable")
}
\seealso{
\code{\link{binning}}, \code{\link{smbinning}}.
}
