% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{plot.performance_bin}
\alias{plot.performance_bin}
\title{Visualize Performance for an "performance_bin" Object}
\usage{
\method{plot}{performance_bin}(x, typographic = TRUE, ...)
}
\arguments{
\item{x}{an object of class "performance_bin", usually, a result of a call to performance_bin().}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{...}{further arguments to be passed from or to other methods.}
}
\description{
It generates plots for understand frequency, WoE by bins using performance_bin.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats

set.seed(123)
carseats[sample(seq(NROW(carseats)), 20), "Advertising"] <- NA

# Change the target variable to 0(negative) and 1(positive).
carseats$US_2 <- ifelse(carseats$US \%in\% "Yes", 1, 0)

# Binnig from Advertising to Advertising_bin.
breaks <- c(-1,  0,  6, 29)
carseats$Advertising_bin <- cut(carseats$Advertising, breaks)

# Diagnose performance binned variable.
perf <- performance_bin(carseats$US_2, carseats$Advertising_bin) 
perf
summary(perf)

plot(perf)

# Diagnose performance binned variable without NA
perf <- performance_bin(carseats$US_2, carseats$Advertising_bin, na.rm = TRUE) 
perf
summary(perf)

plot(perf)
plot(perf, typographic = FALSE)

}
\seealso{
\code{\link{performance_bin}}, \code{\link{summary.performance_bin}}, \code{\link{binning_by}}, 
\code{\link{plot.optimal_bins}}.
}
