% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform}
\alias{transform}
\title{Data Transformations}
\usage{
transform(
  x,
  method = c("zscore", "minmax", "log", "log+1", "sqrt", "1/x", "x^2", "x^3",
    "Box-Cox", "Yeo-Johnson")
)
}
\arguments{
\item{x}{numeric vector for transformation.}

\item{method}{method of transformations.}
}
\value{
An object of transform class.
Attributes of transform class is as follows.
\itemize{
  \item method : method of transformation data.
  \itemize{
    \item Standardization
      \itemize{
        \item "zscore" : z-score transformation. (x - mu) / sigma
        \item "minmax" : minmax transformation. (x - min) / (max - min)
      }
    \item Resolving Skewness
    \itemize{
      \item "log" : log transformation. log(x)
      \item "log+1" : log transformation. log(x + 1). Used for values that contain 0.
      \item "sqrt" : square root transformation.
      \item "1/x" : 1 / x transformation
      \item "x^2" : x square transformation
      \item "x^3" : x^3 square transformation
      \item "Box-Cox" : Box-Box transformation
      \item "Yeo-Johnson" : Yeo-Johnson transformation
    }
  }
}
}
\description{
Performs variable transformation for standardization and resolving skewness
of numerical variables.
}
\details{
transform() creates an transform class.
The `transform` class includes original data, transformed data,
and method of transformation.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Standardization ------------------------------
advertising_minmax <- transform(carseats$Advertising, method = "minmax")
advertising_minmax
summary(advertising_minmax)
plot(advertising_minmax)

# Resolving Skewness  --------------------------
advertising_log <- transform(carseats$Advertising, method = "log")
advertising_log
summary(advertising_log)

# plot(advertising_log)

# plot(advertising_log, typographic = FALSE)

# Using dplyr ----------------------------------
library(dplyr)

carseats \%>\%
  mutate(Advertising_log = transform(Advertising, method = "log+1")) \%>\%
  lm(Sales ~ Advertising_log, data = .)
  
}
\seealso{
\code{\link{summary.transform}}, \code{\link{plot.transform}}.
}
