% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{diagnose_paged_report}
\alias{diagnose_paged_report}
\alias{diagnose_paged_report.data.frame}
\title{Reporting the information of data diagnosis}
\usage{
diagnose_paged_report(.data, ...)

\method{diagnose_paged_report}{data.frame}(
  .data,
  output_format = c("pdf", "html"),
  output_file = NULL,
  output_dir = tempdir(),
  browse = TRUE,
  title = "Data Diagnosis Report",
  subtitle = deparse(substitute(.data)),
  author = "dlookr",
  abstract_title = "Report Overview",
  abstract = NULL,
  title_color = "white",
  subtitle_color = "gold",
  thres_uniq_cat = 0.5,
  thres_uniq_num = 5,
  flag_content_zero = TRUE,
  flag_content_minus = TRUE,
  flag_content_missing = TRUE,
  cover_img = NULL,
  create_date = Sys.time(),
  logo_img = NULL,
  theme = c("orange", "blue"),
  sample_percent = 100,
  is_tbl_dbi = FALSE,
  base_family = NULL,
  ...
)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{...}{arguments to be passed to pagedown::chrome_print().}

\item{output_format}{report output type. Choose either "pdf" and "html".
"pdf" create pdf file by rmarkdown::render() and pagedown::chrome_print(). so, 
you needed Chrome web browser on computer.  
"html" create html file by rmarkdown::render().}

\item{output_file}{name of generated file. default is NULL.}

\item{output_dir}{name of directory to generate report file. default is tempdir().}

\item{browse}{logical. choose whether to output the report results to the browser.}

\item{title}{character. title of report. default is "Data Diagnosis Report".}

\item{subtitle}{character. subtitle of report. default is name of data.}

\item{author}{character. author of report. default is "dlookr".}

\item{abstract_title}{character. abstract title of report. default is 
"Report Overview".}

\item{abstract}{character. abstract of report.}

\item{title_color}{character. color of title. default is "white".}

\item{subtitle_color}{character. color of subtitle. default is "gold".}

\item{thres_uniq_cat}{numeric. threshold to use for "Unique Values - 
Categorical Variables". default is 0.5.}

\item{thres_uniq_num}{numeric. threshold to use for "Unique Values - 
Numerical Variables". default is 5.}

\item{flag_content_zero}{logical. whether to output "Zero Values" information. 
the default value is TRUE, and the information is displayed.}

\item{flag_content_minus}{logical. whether to output "Minus Values" information. 
the default value is TRUE, and the information is displayed.}

\item{flag_content_missing}{logical. whether to output "Missing Value" information. 
the default value is TRUE, and the information is displayed.}

\item{cover_img}{character. name of cover image.}

\item{create_date}{Date or POSIXct, character. The date on which the report is generated. 
The default value is the result of Sys.time().}

\item{logo_img}{character. name of logo image file on top right.}

\item{theme}{character. name of theme for report. support "orange" and "blue". 
default is "orange".}

\item{sample_percent}{numeric. Sample percent of data for performing Diagnosis. 
It has a value between (0, 100]. 100 means all data, and 5 means 5\% of sample data.
This is useful for data with a large number of observations.}

\item{is_tbl_dbi}{logical. whether .data is a tbl_dbi object.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\value{
No return value. This function only generates a report.
}
\description{
The diagnose_paged_report() paged report the information 
for diagnosing the quality of the data.
}
\details{
Generate generalized data diagnostic reports automatically.
You can choose to output to pdf and html files.
This is useful for diagnosing a data frame with a large number of variables
than data with a small number of variables.

Create an  PDF through the Chrome DevTools Protocol. If you want to create PDF, 
Google Chrome or Microsoft Edge (or Chromium on Linux) must be installed prior to using this function.
If not installed, you must use output_format = "html".
}
\section{Reported information}{

Reported from the data diagnosis is as follows.

\itemize{
  \item Overview
  \itemize{
    \item Data Structures 
    \item Job Informations
    \item Warnings
    \item Variables
  } 
  \item Missing Values
  \itemize{
    \item List of Missing Values
    \item Visualization
  } 
  \item Unique Values
  \itemize{
    \item Categorical Variables
    \item Numerical Variables
  } 
  \item Categorical Variable Diagnosis
  \itemize{
     \item Top Ranks
  }
  \item Numerical Variable Diagnosis
  \itemize{
    \item Distribution
    \itemize{
      \item Zero Values
      \item Minus Values
    }
    \item Outliers
    \itemize{
      \item List of Outliers
      \item Individual Outliers
    }
  }
}

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}

\examples{
\donttest{
if (FALSE) {
# create dataset
heartfailure2 <- dlookr::heartfailure
heartfailure2[sample(seq(NROW(heartfailure2)), 20), "sodium"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 5), "smoking"] <- NA
heartfailure2[sample(seq(NROW(heartfailure2)), 2), "time"] <- 0
heartfailure2[sample(seq(NROW(heartfailure2)), 1), "creatinine"] <- -0.3
 
# create pdf file. file name is Diagnosis_Paged_Report.pdf
diagnose_paged_report(heartfailure2)

# create pdf file. file name is Diagn.pdf. and change cover image
cover <- file.path(system.file(package = "dlookr"), "report", "cover2.jpg")
diagnose_paged_report(heartfailure2, cover_img = cover, title_color = "gray",
  output_file = "Diagn.pdf")

# create pdf file. file name is ./Diagn.pdf and not browse
cover <- file.path(system.file(package = "dlookr"), "report", "cover3.jpg")
diagnose_paged_report(heartfailure2, output_dir = ".", cover_img = cover, 
  flag_content_missing = FALSE, output_file = "Diagn.pdf", browse = FALSE)

# create pdf file. file name is Diagnosis_Paged_Report.html
diagnose_paged_report(heartfailure2, output_format = "html")
}
}

}
\seealso{
\code{\link{diagnose_paged_report.tbl_dbi}}.
}
