% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{maybe_cache}
\alias{maybe_cache}
\title{Cache a File if Necessary}
\usage{
maybe_cache(
  source_path,
  appname,
  filename = construct_processed_filename(source_path),
  process_f = readRDS,
  process_args = NULL,
  write_f = saveRDS,
  write_args = NULL,
  force_process = FALSE
)
}
\arguments{
\item{source_path}{Character scalar; the path to the raw file. Paths starting
with \code{http://}, \code{http://}, \code{http://}, or \code{http://} will
be downloaded to a temp file if the processed version is not already
available.}

\item{appname}{Character; the name of the application that will "own" the
cache, such as the name of a package.}

\item{filename}{Character; an optional filename for the cached version of the
file. By default, a filename is constructed using
\code{\link{construct_processed_filename}}}

\item{process_f}{A function or one-sided formula to use to process the source
file. \code{source_path} will be passed as the first argument to this
function. Defaults to \code{read_f}.}

\item{process_args}{An optional list of additional arguments to
\code{process_f}.}

\item{write_f}{A function or one-sided formula to use to save the processed
file. The processed object will be passed as the first argument to this
function, and \code{target_path} will be passed as the second argument.
Defaults to \code{\link[base]{saveRDS}}.}

\item{write_args}{An optional list of additional arguments to \code{write_f}.}

\item{force_process}{A logical scalar indicating whether we should process
the source file even if the target already exists. This can be particularly
useful if you wish to redownload a file.}
}
\value{
The normalized \code{target_path}.
}
\description{
This function wraps \code{\link{maybe_process}}, specifying the app's cache
directory.
}
\examples{
if (interactive()) {
  target_path <- maybe_cache(
    "https://query.data.world/s/owqxojjiphaypjmlxldsp566lck7co",
    appname = "dlr",
    process_f = read.csv
  )
  target_path

  unlink(target_path)
}
}
