% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_frequency.R
\name{plot_frequency}
\alias{plot_frequency}
\title{\code{ggplot} type barplots representing frequencies for each vars.cat by
partition level.}
\usage{
plot_frequency(
  data,
  partition.name,
  vars.cat,
  vars.cat.names = NULL,
  binary.simplify = TRUE,
  unclass.name = "Unclassified",
  include.unclass = FALSE
)
}
\arguments{
\item{data}{The dataset.}

\item{partition.name}{string. Name of the partition (in data). The partition
variable should be a factor.}

\item{vars.cat}{vector of strings. variables to plot (categorical only).}

\item{vars.cat.names}{Optional. Names for displaying the categorical
variables. (given in the same order than \code{vars.cat})}

\item{binary.simplify}{boolean. Should only the 1st level be kept for binary
variables in \code{vars.cat}?}

\item{unclass.name}{If applicable, name for the unclassified observations in
the partition.}

\item{include.unclass}{boolean, should boxplot be displayed for the
unclassified or should they be excluded from the plot.}
}
\value{
\code{ggplot} object.
}
\description{
\code{ggplot} type barplots representing frequencies for each vars.cat by
partition level.
}
\examples{
data(cancer, package = "survival")
cancer$status <- factor(cancer$status)
plot_frequency(data = cancer, partition.name = "status",
                  vars.cat = c("sex", "ph.ecog"))

## With unclassifieds
cancer$status.2 <- as.character(cancer$status)
cancer$status.2[sample(1:nrow(cancer), 30)] <- "Unclassif."
cancer$status.2 <- factor(cancer$status.2)
plot_frequency(data = cancer, partition.name = "status.2",
               vars.cat = c("sex", "ph.ecog"),
               unclass.name = "Unclassif.", include.unclass = TRUE)

## With unclassifieds (as NA)
cancer$status.3 <- cancer$status
cancer$status.3[sample(1:nrow(cancer), 30)] <- NA
plot_frequency(data = cancer, partition.name = "status.3",
               vars.cat = c("sex", "ph.ecog"),
               unclass.name = NA, include.unclass = TRUE)

plot_frequency(data = cancer, partition.name = "status.3",
               vars.cat = c("sex", "ph.ecog", "ph.karno"),
               binary.simplify = FALSE,
               unclass.name = NA, include.unclass = FALSE)
}
