% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doRedis.R
\name{setExport}
\alias{setExport}
\title{Manually add symbol names to the worker environment export list.}
\usage{
setExport(names = c())
}
\arguments{
\item{names}{A character vector of symbol names to export.}
}
\value{
\code{names} is invisibly returned.
}
\description{
The setExport function lets users manually declare symbol names
of corresponding objects that should be exported to workers.
}
\details{
The \code{foreach} function includes a similar \code{.export} parameter.

We provide this supplemental export option for users without direct access
to the \code{foreach} function, for example, when \code{foreach} is used
inside another package.
}
\examples{
\dontrun{
require("doRedis")
registerDoRedis("work queue")
startLocalWorkers(n=1, queue="work queue")

f <- function() pi

foreach(1) \%dopar\% eval(call("f"))
# Returns the error:
# Error in eval(call("f")) : task 1 failed - could not find function "f"

# Manuall export the symbol f:
setExport("f")
foreach(1) \%dopar\% eval(call("f"))
# Ok then.
#[[1]]
#[1] 3.141593
removeQueue("work queue")
}

}
