% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/top2vec.R
\name{update.top2vec}
\alias{update.top2vec}
\title{Update a Top2vec model}
\usage{
\method{update}{top2vec}(
  object,
  type = c("umap", "hdbscan"),
  umap = object$umap_FUN,
  trace = FALSE,
  ...
)
}
\arguments{
\item{object}{an object of class \code{top2vec} as returned by \code{\link{top2vec}}}

\item{type}{a character string indicating what to udpate. Either 'umap' or 'hdbscan' where the former (type = 'umap') indicates to 
update the umap as well as the hdbscan procedure and the latter (type = 'hdbscan') indicates to update only the hdbscan step.}

\item{umap}{see \code{umap} argument in \code{\link{top2vec}}}

\item{trace}{logical indicating to print evolution of the algorithm}

\item{...}{further arguments either passed on to \code{\link[dbscan]{hdbscan}} in case type is 'hdbscan' or to \code{\link[uwot]{umap}}
in case type is 'umap'}
}
\value{
an updated top2vec object
}
\description{
Update a Top2vec model by updating the UMAP dimension reduction together with the HDBSCAN clustering
or update only the HDBSCAN clustering
}
\examples{
# For an example, look at the documentation of ?top2vec
}
