% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document.R
\name{document}
\alias{document}
\title{Document (Chunks of) an R Code File}
\usage{
document(file_name, working_directory = NULL, output_directory = tempdir(),
  dependencies = NULL, sanitize_Rd = TRUE, runit = FALSE,
  check_package = TRUE, clean = FALSE, ...)
}
\arguments{
\item{file_name}{The name of the R code file to be documented.}

\item{working_directory}{A working directory. Keep the default.}

\item{output_directory}{The directory to put the documentation into.}

\item{dependencies}{a character vector of package names the functions depend
on.}

\item{sanitize_Rd}{Remove strange characters from \code{Rdconv}?
Do not bother, this is for Unit testing only.
on.}

\item{runit}{Convert the text received from the help files if running RUnit?
Do not bother, this is for Unit testing only.}

\item{check_package}{Run R CMD check on the sources? See
\bold{Note} below.}

\item{clean}{Delete the working directory?}

\item{...}{Arguments passed to \code{\link{get_lines_between_tags}}.}
}
\value{
A list containing
\describe{
    \item{pdf_path}{The path to the pdf file produced.}
    \item{txt_path}{The path to the text file produced.}
    \item{html_path}{The path to the html file produced.}
    \item{check_result}{A list giving the R CMD check results.}
}
}
\description{
Document (Chunks of) an R Code File
}
\note{
One of the main features of 'R CMD check' is checking for 
code/documentation mismatches (it behaves pretty much like doxygen).
No build system can check whether your documentation is useful, but 'R CMD
check' checks if it is formally matching your code. This check is the basic 
idea behind \pkg{document}. The posibility to disable the R CMD check is
there to disable cpu consuming checks while testing the package. Stick with 
the default! 
And do not forget to export your functions using the line\cr
#' @export\cr
if you provide examples.
}
\examples{
\donttest{
res <- document(file_name = system.file("tests", "files", "minimal.R", 
                                        package = "document"), 
                check_package = FALSE) # this is for the sake of CRAN cpu
                # time only. _Always_ stick with the default!

# View R CMD check results.
cat(res[["check_result"]][["stdout"]], sep = "\\n")
cat(res[["check_result"]][["stderr"]], sep = "\\n")

# Copy docmentation to current working directory.
# This writes to your disk, so it's disabled. 
# Remove or comment out the next line to enable.
if (FALSE) 
    file.copy(res[["pdf_path"]], getwd())
}
}
\author{
Andreas Dominik Cullmann, <adc-r@arcor.de>
}
