% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_load_streetnet.R
\name{dodgr_save_streetnet}
\alias{dodgr_save_streetnet}
\title{Save a weighted streetnet to a local file}
\usage{
dodgr_save_streetnet(net, filename = NULL)
}
\arguments{
\item{net}{\code{data.frame} or equivalent object representing the weighted
network graph.}

\item{filename}{Name with optional full path of file in which to save the
input \code{net}. The extension \code{.Rds} will be automatically appended, unless
specified otherwise.}
}
\description{
The \link{weight_streetnet} function returns a single \code{data.frame} object,
the processing of which also relies on a couple of cached lookup-tables to
match edges in the \code{data.frame} to objects in the original input data. It
automatically calculates and caches a contracted version of the same graph,
to enable rapid conversion between contracted and uncontracted forms. This
function saves all of these items in a single \code{.Rds} file, so that a the
result of a \link{weight_streetnet} call can be rapidly loaded into a
workspace in subsequent sessions, rather than re-calculating the entire
weighted network.
}
\note{
This may take some time if \link{dodgr_cache_off} has been called.
The contracted version of the graph is also saved, and so must be calculated
if it has not previously been automatically cached.
}
\examples{
net <- weight_streetnet (hampi)
f <- file.path (tempdir (), "streetnet.Rds")
dodgr_save_streetnet (net, f)
clear_dodgr_cache () # rm cached objects from tempdir
# at some later time, or in a new R session:
net <- dodgr_load_streetnet (f)
}
\seealso{
Other cache: 
\code{\link{clear_dodgr_cache}()},
\code{\link{dodgr_cache_off}()},
\code{\link{dodgr_cache_on}()},
\code{\link{dodgr_load_streetnet}()}
}
\concept{cache}
