% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domin.r
\name{print.domin}
\alias{print.domin}
\title{Print method for \code{domin}}
\usage{
\method{print}{domin}(x, ...)
}
\arguments{
\item{x}{an object of class "domin".}

\item{...}{further arguments passed to or from other methods. Not used currently.}
}
\value{
The "domin" object with altered column and row names for conditional and complete dominance results as displayed in the console.
}
\description{
Reports formatted results from \code{domin} class object.
}
\details{
The print method for class \code{domin} objects reports out the following results:
\itemize{
\item{Fit statistic for the full model.  The fit statistic for the all subsets model is reported here if there are any entries in \code{all}.  The fit statistic for the constant model is reported here if there are any entries in \code{consmodel}.}
\item{Matrix describing general dominance statistics, standardized general dominance statistics, and the ranking of the general dominance statistics}
\item{If \code{conditional} is \code{TRUE}, matrix describing the conditional dominance designations}
\item{If \code{complete} is \code{TRUE}, matrix describing the complete dominance designations}
\item{If following \code{summary.domin}, matrix describing the strongest dominance designations between all independent variables}
\item{If there are entries in \code{sets} and/or \code{all} the terms included in each set as well as the terms in all subsets are reported}}
The \code{domin} print method alters dimension names for readability and they do not display as stored in the original \code{domin} object.
}
