% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula_list.R
\name{fmllst2Fml}
\alias{fmllst2Fml}
\title{Translate \code{formula_list} into \code{Formula::Formula}}
\usage{
fmllst2Fml(fmllst, drop_lhs = NULL)
}
\arguments{
\item{fmllst}{A \code{formula_list} classed object.}

\item{drop_lhs}{An integer vector.

Used as a selection vector to remove left hand side names prior to
generating the \code{Formula} object. This vector must be composed of
integers (e.g., 1L and not 1).

This is useful for some \code{Formulas} that do not have a separate
LHS for each LHS model part (e.g., \code{\link[pscl:zeroinfl]{pscl::zeroinfl}}) but are required
to have separte LHS parts by \code{formula_list}.}
}
\value{
A \code{Formula::Formula} object.
}
\description{
Translates \code{\link{formula_list}} objects into a \code{\link[Formula:Formula]{Formula::Formula}}
}
