% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearest_neighbours_on_a_torus.R
\name{plot.nnt}
\alias{plot.nnt}
\title{Plot diagnostics for an nnt object}
\usage{
\method{plot}{nnt}(x, ...)
}
\arguments{
\item{x}{an object of class \code{c("nnt")}, a result of
a call to \code{\link{nnt}}.}

\item{...}{Further arguments to be passed to \code{\link[graphics]{plot}},
or \code{\link[graphics]{points}}.}
}
\value{
Nothing is returned.
}
\description{
\code{plot} method for an objects of class \code{c("nnt")}.
}
\details{
This function is only applicable in 1 or 2 dimensions, that is,
  when \code{ncol(x$data)} = 1 or 2.  It provides a visual check that the
  wrapping of variables is working as intended, in cases where the
  number of query points, that is, \code{nrow(x$query)} is small
  enough that sets of nearest neighbours do not overlap much.

  If \code{ncol(x$data)} = 1 then the index of each observation is plotted
  against its value, using a plotting character \code{pch = 1}.  A vertical
  line is superimposed at each value in \code{x$query} and the \code{x$k$}
  nearest neighbours of each line are colour-coded.

  If \code{ncol(x$data)} = 2 then \code{x$data[, 2]} is plotted against
  \code{x$data[, 1]}, using a plotting character \code{pch = 1}.  Each point
  in \code{x$query} is plotted with a cross and the \code{x$k$}
  nearest neighbours of each point are colour-coded.

  Colours of the lines/crosses and nearest neighbour points can be set sing an
  argument \code{col}.  If a variable is wrapped then the default plotting
  limits are set using the corresponding values in \code{x$ranges}.
}
\section{Examples}{

See the examples in \code{\link{nnt}}.
}

\seealso{
\code{\link{nnt}} for nearest neighbour with some variables
  wrapped on a torus.
}
