% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{dkcrop}
\alias{dkcrop}
\title{crop a mesh}
\usage{
dkcrop(mesh, y)
}
\arguments{
\item{mesh}{object of class mesh3d}

\item{y}{numeric vector indicating which polygons should be cropped; or an object of class \code{polygon.network}}
}
\value{
A new object of class mesh3d for which all polygons out of y have been removed.
}
\description{
Crop a 3d triangle mesh.
}
\examples{
#Crop above a certain threshold:
mythreshold <- quantile(elev(dkmodel$basin), 0.5)
mypolynetwork <- poly.network(dkmodel$basin, elev(dkmodel$basin),
lwr.limit = mythreshold)
mynewmesh <- dkcrop(dkmodel$basin, mypolynetwork)
dkmap(mynewmesh, elev(mynewmesh))

#Crop the sharpest dental elements:
sharpmesh <- dkcrop(dkmodel$basin, poly.network(dkmodel$basin,
Rvcg::vcgCurve(dkmodel$basin)$meanitmax,
lwr.limit = quantile(Rvcg::vcgCurve(dkmodel$basin)$meanitmax, 0.8),
min.size = 50))
dkmap(sharpmesh, arc(sharpmesh), col = "arc", col.levels = 20,
min.range = -20, max.range = 20)
#Map of the sharpest elements' elevation, slope and orientation;
dkmap(sharpmesh, elev(sharpmesh), col = "elev")
dkmap(sharpmesh, slope(sharpmesh), col = "slope", col.levels = 9,
min.range = 0, max.range = 90)
dkmap(sharpmesh, orient(sharpmesh), col = "orient", col.levels = 8,
min.range = 0, max.range = 360)

}
