##' C code for R parser
##'
##' @return A string for generating C tree walker
##' @author Matthew L. Fidler
##' @keywords internal
##' @export
dpRparse <- function(){return("/* Rparse.c --- Parse an arbitrary grammar in R.\n * \n * Filename: Rparse.c\n * Description: Template for parsing an arbitrary grammar in R.\n * Author: Matthew L. Fidler\n * Maintainer: Matthew L. Fidler\n * Created: Mon Dec  5 14:37:45 2016 (-0600)\n * \n * This is licensed under BSD 3-Clause License\n */\n\n/* Code: */\n\n#include <R.h>\n#include <Rdefines.h>\n#include <dparser.h>\n\n<%=pasertables%>;\n\nSEXP dparse_<%=gram%>_digest(){\n  // return the digest of the grammar that was used.\n  // Probably too much PROTECTion here.  I don't think that this allocates anything.\n  SEXP ret = PROTECT(allocVector(STRSXP,1));\n  SET_STRING_ELT(ret,0,mkChar(\"<%=digest%>\"));\n  UNPROTECT(1);\n  return ret;\n}\n  \nSEXP dparse_<%=gram%>(SEXP sexp_fileName,\n                      SEXP sexp_start_state,\n                      SEXP sexp_save_parse_tree,\n                      SEXP sexp_partial_parses,\n                      SEXP sexp_compare_stacks,\n                      SEXP sexp_commit_actions_interval,\n                      SEXP sexp_fixup,\n                      SEXP sexp_fixup_ebnf,\n                      SEXP sexp_nogreedy,\n                      SEXP sexp_noheight,\n                      SEXP sexp_use_filename,\n		      SEXP sexp_sizeof_parse_node,\n                      SEXP sexp_verbose,\n		      SEXP sexp_children_first,\n                      SEXP fn,\n		      SEXP skip_fn,\n                      SEXP env){\n  dparse_sexp(sexp_fileName,\n	      sexp_start_state,\n	      sexp_save_parse_tree,\n	      sexp_partial_parses,\n	      sexp_compare_stacks,\n	      sexp_commit_actions_interval,\n	      sexp_fixup,\n	      sexp_fixup_ebnf,\n	      sexp_nogreedy,\n	      sexp_noheight,\n	      sexp_use_filename,\n	      sexp_sizeof_parse_node,\n	      sexp_verbose,\n	      sexp_children_first,\n	      fn,\n	      skip_fn,\n	      env,\n	      parser_tables_<%=gram%>);\n  return R_NilValue;\n}\n/* Rparse.c ends here */\n");}
