% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/top-n.R
\name{top_n}
\alias{top_n}
\title{Select top n rows (by value).}
\usage{
top_n(x, n, wt)
}
\arguments{
\item{x}{a \code{\link{tbl}} to filter}

\item{n}{number of rows to return. If \code{x} is grouped, this is
the number of rows per group. May include more than \code{n} if there
are ties.}

\item{wt}{(Optional). The variable to use for ordering. If not specified,
defaults to the last variable in the tbl.}
}
\description{
This is a convenient wrapper that uses \code{\link{filter}} and
\code{\link{min_rank}} to select the top n entries in each group, ordered
by \code{wt}.
}
\examples{
# Find 10 players with most games
if (require("Lahman")) {
players <- group_by(tbl_df(Batting), playerID)
games <- tally(players, G)
top_n(games, 10, n)

# A little nicer with \%>\%
tbl_df(Batting) \%>\%
  group_by(playerID) \%>\%
  tally(G) \%>\%
  top_n(10)

# Find year with most games for each player
tbl_df(Batting) \%>\% group_by(playerID) \%>\% top_n(1, G)
}
}

