% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{coalesce}
\alias{coalesce}
\title{Find first non-missing element}
\usage{
coalesce(x, ...)
}
\arguments{
\item{x, ...}{Vectors. All inputs should either be length 1, or the
same length as \code{x}}
}
\value{
A vector the same length as \code{x} with missing values replaced
  by the first non-missing value.
}
\description{
Given a set of vectors, \code{coelesce} finds the first non-missing value
at each position. This is inspired by the SQL \code{COALESCE} function
which does the same thing for \code{NULL}s.
}
\examples{
# Use a single value to replace all missing values
x <- sample(c(1:5, NA, NA, NA))
coalesce(x, 0L)

# Or match together a complete vector from missing pieces
y <- c(1, 2, NA, NA, 5)
z <- c(NA, NA, 3, 4, 5)
coalesce(y, z)
}
\seealso{
\code{\link{na_if}()} to replace specified values with a \code{NA}.
}

