% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr.R
\name{backend_dbplyr}
\alias{backend_dbplyr}
\alias{db_desc}
\alias{sql_translate_env}
\alias{db_list_tables}
\alias{db_has_table}
\alias{db_data_type}
\alias{db_save_query}
\alias{db_begin}
\alias{db_commit}
\alias{db_rollback}
\alias{db_write_table}
\alias{db_create_table}
\alias{db_insert_into}
\alias{db_create_indexes}
\alias{db_create_index}
\alias{db_drop_table}
\alias{db_analyze}
\alias{db_explain}
\alias{db_query_fields}
\alias{db_query_rows}
\alias{sql_select}
\alias{sql_subquery}
\alias{sql_join}
\alias{sql_semi_join}
\alias{sql_set_op}
\alias{sql_escape_string}
\alias{sql_escape_ident}
\title{Database and SQL generics.}
\usage{
db_desc(x)

sql_translate_env(con)

db_list_tables(con)

db_has_table(con, table)

db_data_type(con, fields)

db_save_query(con, sql, name, temporary = TRUE, ...)

db_begin(con, ...)

db_commit(con, ...)

db_rollback(con, ...)

db_write_table(con, table, types, values, temporary = FALSE, ...)

db_create_table(con, table, types, temporary = FALSE, ...)

db_insert_into(con, table, values, ...)

db_create_indexes(con, table, indexes = NULL, unique = FALSE, ...)

db_create_index(con, table, columns, name = NULL, unique = FALSE, ...)

db_drop_table(con, table, force = FALSE, ...)

db_analyze(con, table, ...)

db_explain(con, sql, ...)

db_query_fields(con, sql, ...)

db_query_rows(con, sql, ...)

sql_select(con, select, from, where = NULL, group_by = NULL,
  having = NULL, order_by = NULL, limit = NULL, distinct = FALSE, ...)

sql_subquery(con, from, name = random_table_name(), ...)

sql_join(con, x, y, vars, type = "inner", by = NULL, ...)

sql_semi_join(con, x, y, anti = FALSE, by = NULL, ...)

sql_set_op(con, x, y, method)

sql_escape_string(con, x)

sql_escape_ident(con, x)
}
\arguments{
\item{con}{A database connection.}

\item{table}{A string, the table name.}

\item{fields}{A list of fields, as in a data frame.}
}
\value{
Usually a logical value indicating success. Most failures should generate
an error. However, \code{db_has_table()} should return \code{NA} if
temporary tables cannot be listed with \code{\link[DBI:dbListTables]{DBI::dbListTables()}} (due to backend
API limitations for example). As a result, you methods will rely on the
backend to throw an error if a table exists when it shouldn't.
}
\description{
The \code{sql_} generics are used to build the different types of SQL queries.
The default implementations in dbplyr generates ANSI 92 compliant SQL.
The \code{db_} generics execute actions on the database. The default
implementations in dbplyr typically just call the standard DBI S4
method.
}
\details{
A few backend methods do not call the standard DBI S4 methods including
\itemize{
\item \code{db_data_type()}: Calls \code{\link[DBI:dbDataType]{DBI::dbDataType()}} for every field
(e.g. data frame column) and returns a vector of corresponding SQL data
types
\item \code{db_save_query()}: Builds and executes a
\code{CREATE [TEMPORARY] TABLE <table> ...} SQL command.
\item \code{db_create_index()}: Builds and executes a
\code{CREATE INDEX <name> ON <table>} SQL command.
\item \code{db_drop_table()}: Builds and executes a
\code{DROP TABLE [IF EXISTS] <table>} SQL command.
\item \code{db_analyze()}: Builds and executes an
\code{ANALYZE <table>} SQL command.
}

Currently, \code{\link[=copy_to]{copy_to()}} is the only user of \code{db_begin()}, \code{db_commit()},
\code{db_rollback()}, \code{db_write_table()}, \code{db_create_indexes()}, \code{db_drop_table()} and
\code{db_analyze()}. If you find yourself overriding many of these
functions it may suggest that you should just override \code{copy_to()}
instead.

\code{db_create_table()} and \code{db_insert_into()} have been deprecated
in favour of \code{db_write_table()}.
}
\keyword{internal}
