% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.r
\name{combine}
\alias{combine}
\title{Combine vectors}
\usage{
combine(...)
}
\arguments{
\item{...}{Vectors to combine.}
}
\description{
\code{combine()} acts like \code{\link[=c]{c()}} or
\code{\link[=unlist]{unlist()}} but uses consistent dplyr coercion rules.

If \code{combine()} it is called with exactly one list argument, the list is
simplified (similarly to \code{unlist(recursive = FALSE)}). \code{NULL} arguments are
ignored. If the result is empty, \code{logical()} is returned.
Use \code{\link[vctrs:vec_c]{vctrs::vec_c()}} if you never want to unlist.
}
\details{
\Sexpr[results=rd, stage=render]{dplyr:::lifecycle("questioning")}
}
\examples{
# combine applies the same coercion rules as bind_rows()
f1 <- factor("a")
f2 <- factor("b")
c(f1, f2)
unlist(list(f1, f2))

combine(f1, f2)
combine(list(f1, f2))
}
\seealso{
\code{bind_rows()} and \code{bind_cols()} in \link{bind}.
}
