% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dq_handsontable.R
\name{dq_handsontable_output}
\alias{dq_handsontable_output}
\alias{dq_render_handsontable}
\title{Adds an uiOutput and renders an enhanced rhandsontable html widget}
\usage{
dq_handsontable_output(id, width = 12L, offset = 0L)

dq_render_handsontable(id, data, context = NULL, filters = "T",
  page_size = 25L, reset = TRUE, sorting = NULL, columns = NULL,
  width_align = FALSE, horizontal_scroll = FALSE, table_param = NULL,
  cols_param = NULL, col_param = NULL, cell_param = NULL,
  session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{id of the element}

\item{width}{width of the table in bootstrap columns}

\item{offset}{optional offset of the column}

\item{data}{data to show in the table, should be a data.frame'ish object, can
also be reactive(Val) or a reactiveValues object holding the data under the
given id (e.g. myReactiveValues[[id]] <- data). In case of reactiveVal(ues)
data will always be in sync with user inputs.}

\item{context}{the context used to specify all ui elements used for this
table, can be omitted which ends up in a randomly generated context
NOTE: this parameter is deprecated and will be removed soon}

\item{filters}{optional character vector, adds filters for each column,
values must be one of "Text", "Select", "Range", "Date", "Auto" or "" (can be
abbreviated) to add a Text-, Select-, Range-, DateRange-, AutocompleteInput
or none, vectors of length one will add a filter of this type for each column
and NA will try to guess proper filters}

\item{page_size}{optional integer, number of items per page, can be one of
10, 25, 50, 100 or any other value(s) which will be added to this list, first
value will be used initially, NULL will disable paging at all}

\item{reset}{optional logical, specify whether to add a button to reset
filters and sort buttons to initial values or not}

\item{sorting}{optional, specify whether to add sort buttons for every column
or not, as normal rhandsontable sorting won't work properly when table is
paged, value can be logical of length one or a vector specifying the initial
sort "col"umn and "dir"ection e.g. c(dir="down", col="Colname")}

\item{columns}{optional, specify which columns to show in the table, useful
in combination with reactive values, which will still hold all the data}

\item{width_align}{optional boolean to align filter widths with hot columns,
should only be used with either horizontal_scroll, stretchH = "all" or a
table fitting in its output element}

\item{horizontal_scroll}{optional boolean to scroll the filter row according
to the hot table, especially useful for tables with many columns}

\item{table_param}{optional list, specify parameters to hand to rhandsontable
table element}

\item{cols_param}{optional list, specify parameters to hand to rhandsontable
cols elements}

\item{col_param}{optional list of lists to specify parameters to hand to
rhandsontable col elements}

\item{cell_param}{optional list of lists to specify parameters to hand to
rhandsontable cells}

\item{session}{shiny session object}
}
\value{
dq_handsontable_output: fluidRow containing the output fields

dq_render_handsontable: the given data
}
\description{
dq_handsontable_output adds a fluidRow containing a column with
the given width, ready to support a dq_handsontable.

dq_render_handsontable renders a rhandsontable into the given
uiOutput id with the given data and parameters. Can also contain several
filters to filter the data and a feature to split the table into several
pages with a given page size. The function will also add all needed
observeEvents to establish the required functionalities. If table is not
readOnly, all user inputs will automatically stored and updated independent
from any filters, sortings or pages.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

library(shiny)
shinyApp(
  ui = fluidPage(
    dq_handsontable_output("randomTable", 9L)
  ),
  server = function(input, output, session) {
    hw <- c("Hello", "my", "funny", "world!")
    data <- data.frame(A = rep(hw, 500), B = hw[c(2,3,4,1)],
      C = 1:500, D = Sys.Date() - 0:499, stringsAsFactors = FALSE)
    dq_render_handsontable("randomTable", data,
      filters = c("A", NA, NA, NA), sorting = c(dir = "up", col = "B"),
      page_size = c(17L, 5L, 500L, 1000L), width_align = TRUE,
      col_param = list(list(col = 1L, type = "dropdown", source = letters)),
      cell_param = list(list(row = 2:9, col = 1:2, readOnly = TRUE))
    )
  }
)

}
}
\seealso{
\code{\link[rhandsontable:rhandsontable]{rhandsontable}},
\code{\link[rhandsontable:hot_cols]{hot_cols}} and
\code{\link[rhandsontable:hot_col]{hot_col}}
}
\author{
richard.kunze
}
