% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_example.R
\name{load_basic_example}
\alias{load_basic_example}
\title{Function \code{load_basic_example}}
\usage{
load_basic_example(envir = parent.frame(), to = getwd(), overwrite = TRUE)
}
\arguments{
\item{envir}{The environment to load the example into.
Defaults to your workspace.
For an insulated workspace,
set \code{envir = new.env(parent = globalenv())}.}

\item{to}{where to write the dynamic report source file
\code{report.Rmd}}

\item{overwrite}{logical, whether to overwrite an
existing file \code{report.Rmd}}
}
\description{
Loads the basic example into your workspace
(or the environment you specify).
Also writes/overwrites the file \code{report.Rmd}.
For a thorough walkthrough of how to set up this example, see the
quickstart vignette: \code{vignette('quickstart')}. Alternatively,
call \code{\link{example_drake}('basic')} to generate an R script
that builds up this example step by step.
}
\examples{
\dontrun{
load_basic_example()
deps(reg1)
deps(my_plan$command[1])
deps(my_plan$command[4])
plot_graph(my_plan)
make(my_plan)
clean(destroy = TRUE)
unlink('report.Rmd')
}
}
