% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Get the last stored error log of a target
that failed to build, or list the targets with error logs.}
\usage{
diagnose(target = NULL, character_only = FALSE, path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), verbose = TRUE)
}
\arguments{
\item{target}{name of the target of the error to get.
Can be a symbol if \code{character_only} is \code{FALSE},
must be a character if \code{character_only} is \code{TRUE}.}

\item{character_only}{logical, whether \code{target} should be treated
as a character or a symbol.
Just like \code{character.only} in \code{library()}.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.}

\item{search}{If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.}

\item{cache}{optional drake cache. See code{\link{new_cache}()}.
If \code{cache} is supplied,
the \code{path} and \code{search} arguments are ignored.}

\item{verbose}{whether to print console messages}
}
\value{
Either a character vector of target names or an object
of class \code{"error"}.
}
\description{
The specified target could be a
completely failed target or a target
that failed initially, retried, then succeeded.
If no target is given, then \code{diagnose()} simply
lists the targets for which a error is retrievable.
Together, functions \code{\link{failed}()} and
\code{diagnose()} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
diagnose() # List all the targets with recorded error logs.
# Define a function doomed to failure.
f <- function(){
  stop("unusual error")
}
# Create a workflow plan doomed to failure.
bad_plan <- drake_plan(my_target = f())
# Running the project should generate an error
# when trying to build 'my_target'.
try(make(bad_plan), silent = FALSE)
failed() # List the failed targets from the last make() (my_target).
# List targets that failed at one point or another
# over the course of the project (my_target).
# Drake keeps all the error logs.
diagnose()
# Get the error log, an object of class "error".
error <- diagnose(my_target)
str(error) # See what's inside the error log.
error$calls # View the traceback. (See the traceback() function).
})
}
}
\seealso{
\code{\link{failed}}, \code{\link{progress}},
\code{\link{readd}}, \code{\link{drake_plan}}, \code{\link{make}}
}
